/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class EncodingFilter
implements Filter {
    private static final String ALREADY_FILTERED_ATTRIBUTE_NAME = EncodingFilter.class.getName() + ".FILTERED";
    public static final String ENCODING = "encoding";
    public static final String FORCE_ENCODING = "forceEncoding";
    public static final String URI_ENCODING = "URIEncoding";
    public static final String URI_BYTES_ENCODING = "URIBytesEncoding";
    public static final String DEFAULT_URI_BYTE_ENCODING = "ISO-8859-1";
    private String encoding;
    private boolean forceEncoding = false;
    private String uriEncoding;
    private String uriBytesEncoding;

    public void init(FilterConfig config) throws ServletException {
        this.encoding = config.getInitParameter(ENCODING);
        try {
            this.validateEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException((Throwable)e);
        }
        String forceEncodingString = config.getInitParameter(FORCE_ENCODING);
        if (forceEncodingString != null) {
            this.forceEncoding = Boolean.parseBoolean(forceEncodingString);
        }
        this.uriEncoding = config.getInitParameter(URI_ENCODING);
        try {
            this.validateEncoding(this.uriEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException((Throwable)e);
        }
        this.uriBytesEncoding = config.getInitParameter(URI_BYTES_ENCODING);
        if (this.uriBytesEncoding == null) {
            this.uriBytesEncoding = DEFAULT_URI_BYTE_ENCODING;
        }
        try {
            this.validateEncoding(this.uriBytesEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void validateEncoding(String encoding) throws UnsupportedEncodingException {
        if (encoding != null && !Charset.isSupported(encoding)) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(ALREADY_FILTERED_ATTRIBUTE_NAME) == null) {
            request.setAttribute(ALREADY_FILTERED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
            if (request.getCharacterEncoding() == null || this.forceEncoding) {
                request.setCharacterEncoding(this.encoding);
            }
            if (this.uriEncoding == null) {
                chain.doFilter(request, response);
            } else {
                EncodingHttpServletRequestWrapper wrapper = new EncodingHttpServletRequestWrapper((HttpServletRequest)request, this.uriEncoding, this.uriBytesEncoding);
                chain.doFilter((ServletRequest)wrapper, response);
            }
            request.removeAttribute(ALREADY_FILTERED_ATTRIBUTE_NAME);
        } else {
            chain.doFilter(request, response);
        }
    }

    private static class EncodingHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final String uriEncoding;
        private final String uriBytesEncoding;

        public EncodingHttpServletRequestWrapper(HttpServletRequest request, String uriEncoding, String uriBytesEncoding) throws IOException {
            super(request);
            this.uriEncoding = uriEncoding;
            this.uriBytesEncoding = uriBytesEncoding;
        }

        public String getServletPath() {
            return this.rebuild(super.getServletPath(), this.uriEncoding, this.uriBytesEncoding);
        }

        public String getPathInfo() {
            return this.rebuild(super.getPathInfo(), this.uriEncoding, this.uriBytesEncoding);
        }

        private String rebuild(String str, String encoding, String bytesEncoding) {
            if (str == null || encoding == null) {
                return str;
            }
            try {
                return new String(str.getBytes(bytesEncoding), encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

