/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;

public class RangeLengthValidator
implements ScalarFieldValidator {
    private final String messageKey;
    private final int min;
    private final int max;

    public RangeLengthValidator(int min, int max) {
        this(min, max, "valid.rangeLength");
    }

    public RangeLengthValidator(int min, int max, String messageKey) {
        this.min = min;
        this.max = max;
        this.messageKey = messageKey;
    }

    public void validate(ValidationContext context, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (StringUtils.isEmpty(str)) {
                return;
            }
            int length = str.length();
            if (length >= this.min && length <= this.max) {
                return;
            }
        } else if (value == null) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setKey(this.messageKey);
        messageInfo.setArguments(this.min, this.max);
        context.addMessageInfo(messageInfo);
    }
}

