/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.controller.impl;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.internal.controller.ActionProcessor;
import org.seasar.cubby.internal.controller.ActionResultWrapper;
import org.seasar.cubby.internal.controller.ThreadContext;
import org.seasar.cubby.internal.controller.impl.ActionProcessorImpl;
import org.seasar.cubby.plugin.Plugin;
import org.seasar.cubby.plugin.PluginRegistry;
import org.seasar.cubby.plugin.RequestProcessingInvocation;
import org.seasar.cubby.routing.PathInfo;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.spi.RequestParserProvider;

public class RequestProcessingInvocationImpl
implements RequestProcessingInvocation {
    private final ActionProcessor actionProcessor = new ActionProcessorImpl();
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final PathInfo pathInfo;
    private final Iterator<Plugin> pluginsIterator;

    public RequestProcessingInvocationImpl(HttpServletRequest request, HttpServletResponse response, PathInfo pathInfo) {
        this.request = request;
        this.response = response;
        this.pathInfo = pathInfo;
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        this.pluginsIterator = pluginRegistry.getPlugins().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void proceed() throws Exception {
        if (this.pluginsIterator.hasNext()) {
            Plugin plugin = this.pluginsIterator.next();
            plugin.invokeRequestProcessing(this);
        } else {
            HttpServletRequest request = this.getRequest();
            RequestParserProvider requestParserProvider = ProviderFactory.get(RequestParserProvider.class);
            Map<String, Object[]> parameterMap = requestParserProvider.getParameterMap(request);
            request.setAttribute("org.seasar.cubby.params", parameterMap);
            Routing routing = this.pathInfo.dispatch(parameterMap);
            ThreadContext.enter(request, this.response);
            try {
                ActionResultWrapper actionResultWrapper = this.actionProcessor.process(request, this.response, routing);
                actionResultWrapper.execute(request, this.response);
            }
            finally {
                ThreadContext.exit();
            }
        }
        return null;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public PathInfo getPathInfo() {
        return this.pathInfo;
    }
}

