/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class IntPtg
extends Ptg {
    public static final int SIZE = 3;
    public static final byte sid = 30;
    private short field_1_value;

    private IntPtg() {
    }

    public IntPtg(RecordInputStream in) {
        this.setValue(in.readShort());
    }

    public IntPtg(String formulaToken) {
        this.setValue(Short.parseShort(formulaToken));
    }

    public void setValue(short value) {
        this.field_1_value = value;
    }

    public short getValue() {
        return this.field_1_value;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 30;
        LittleEndian.putShort(array, offset + 1, this.getValue());
    }

    public int getSize() {
        return 3;
    }

    public String toFormulaString(Workbook book) {
        return "" + this.getValue();
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        IntPtg ptg = new IntPtg();
        ptg.field_1_value = this.field_1_value;
        return ptg;
    }
}

