/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hslf.model.Background;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.Notes;
import org.apache.poi.hslf.model.Placeholder;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.SlideMaster;
import org.apache.poi.hslf.model.TextBox;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.SlideAtom;
import org.apache.poi.hslf.record.SlideListWithText;

public class Slide
extends Sheet {
    private int _refSheetNo;
    private int _sheetNo;
    private int _slideNo;
    private org.apache.poi.hslf.record.Slide _slide;
    private SlideListWithText.SlideAtomsSet _atomSet;
    private TextRun[] _runs;
    private TextRun[] _otherRuns;
    private Notes _notes;
    private Background _background;

    public Slide(org.apache.poi.hslf.record.Slide slide, Notes notes, SlideListWithText.SlideAtomsSet atomSet, int slideIdentifier, int slideNumber) {
        this._slide = slide;
        this._notes = notes;
        this._atomSet = atomSet;
        this._refSheetNo = slide.getSheetId();
        this._sheetNo = slideIdentifier;
        this._slideNo = slideNumber;
        this._otherRuns = Slide.findTextRuns(this._slide.getPPDrawing());
        Vector textRuns = new Vector();
        if (this._atomSet != null) {
            Slide.findTextRuns(this._atomSet.getSlideRecords(), textRuns);
        }
        this._runs = new TextRun[textRuns.size() + this._otherRuns.length];
        int i = 0;
        for (i = 0; i < textRuns.size(); ++i) {
            this._runs[i] = (TextRun)textRuns.get(i);
            this._runs[i].setSheet(this);
        }
        for (int k = 0; k < this._otherRuns.length; ++k) {
            this._runs[i] = this._otherRuns[k];
            this._runs[i].setSheet(this);
            ++i;
        }
    }

    public Slide(int sheetNumber, int sheetRefId, int slideNumber) {
        this._slide = new org.apache.poi.hslf.record.Slide();
        this._refSheetNo = sheetRefId;
        this._sheetNo = sheetNumber;
        this._slideNo = slideNumber;
    }

    public void setNotes(Notes notes) {
        this._notes = notes;
        SlideAtom sa = this._slide.getSlideAtom();
        if (notes == null) {
            sa.setNotesID(0);
        } else {
            sa.setNotesID(notes._getSheetNumber());
        }
    }

    public void setSlideNumber(int newSlideNumber) {
        this._slideNo = newSlideNumber;
    }

    public TextBox addTitle() {
        Placeholder pl = new Placeholder();
        pl.setShapeType(1);
        pl.getTextRun().setRunType(0);
        pl.setText("Click to edit title");
        pl.setAnchor(new Rectangle(54, 48, 612, 90));
        this.addShape(pl);
        return pl;
    }

    public String getTitle() {
        TextRun[] txt = this.getTextRuns();
        for (int i = 0; i < txt.length; ++i) {
            int type = txt[i].getRunType();
            if (type != 6 && type != 0) continue;
            String title = txt[i].getText();
            return title;
        }
        return null;
    }

    public TextRun[] getTextRuns() {
        return this._runs;
    }

    public int _getSheetRefId() {
        return this._refSheetNo;
    }

    public int _getSheetNumber() {
        return this._sheetNo;
    }

    public int getSlideNumber() {
        return this._slideNo;
    }

    public org.apache.poi.hslf.record.Slide getSlideRecord() {
        return this._slide;
    }

    public Notes getNotesSheet() {
        return this._notes;
    }

    protected PPDrawing getPPDrawing() {
        return this._slide.getPPDrawing();
    }

    protected SlideListWithText.SlideAtomsSet getSlideAtomsSet() {
        return this._atomSet;
    }

    public MasterSheet getMasterSheet() {
        SlideMaster[] master = this.getSlideShow().getSlidesMasters();
        SlideAtom sa = this._slide.getSlideAtom();
        int masterId = sa.getMasterID();
        for (int i = 0; i < master.length; ++i) {
            if (masterId != master[i]._getSheetNumber()) continue;
            return master[i];
        }
        throw new RuntimeException("Master slide not found for slide " + this._slideNo);
    }

    public void setMasterSheet(MasterSheet master) {
        SlideAtom sa = this._slide.getSlideAtom();
        int sheetNo = master._getSheetNumber();
        sa.setMasterID(sheetNo);
    }

    public ColorSchemeAtom getColorScheme() {
        return this._slide.getColorScheme();
    }

    public Background getBackground() {
        if (this._background == null) {
            PPDrawing ppdrawing = this.getPPDrawing();
            EscherContainerRecord dg = (EscherContainerRecord)ppdrawing.getEscherRecords()[0];
            EscherContainerRecord spContainer = null;
            List ch = dg.getChildRecords();
            Iterator it = ch.iterator();
            while (it.hasNext()) {
                EscherRecord rec = (EscherRecord)it.next();
                if (rec.getRecordId() != -4092) continue;
                spContainer = (EscherContainerRecord)rec;
                break;
            }
            this._background = new Background(spContainer, null);
            this._background.setSheet(this);
        }
        return this._background;
    }

    public void setFollowMasterBackground(boolean flag) {
        SlideAtom sa = this._slide.getSlideAtom();
        sa.setFollowMasterBackground(flag);
    }

    public boolean getFollowMasterBackground() {
        SlideAtom sa = this._slide.getSlideAtom();
        return sa.getFollowMasterBackground();
    }
}

