/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.FileItem;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;

public class FileRegexpValidator
implements ScalarFieldValidator {
    private final String messageKey;
    private final Pattern pattern;

    public FileRegexpValidator(String regex) {
        this(regex, "valid.fileRegexp");
    }

    public FileRegexpValidator(String regex, String messageKey) {
        this(Pattern.compile(regex), messageKey);
    }

    public FileRegexpValidator(Pattern pattern) {
        this(pattern, "valid.fileRegexp");
    }

    public FileRegexpValidator(Pattern pattern, String messageKey) {
        this.pattern = pattern;
        this.messageKey = messageKey;
    }

    public void validate(ValidationContext context, Object value) {
        if (value instanceof FileItem) {
            FileItem fileItem = (FileItem)value;
            Matcher matcher = this.pattern.matcher(fileItem.getName());
            if (matcher.matches()) {
                return;
            }
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setKey(this.messageKey);
            context.addMessageInfo(messageInfo);
        }
    }
}

