/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.factory;

import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.impl.BeanDescImpl;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.MapUtil;

public class BeanDescFactory {
    private static volatile boolean initialized;
    private static Map beanDescCache;

    protected BeanDescFactory() {
    }

    public static BeanDesc getBeanDesc(Class clazz) {
        BeanDesc beanDesc;
        if (!initialized) {
            BeanDescFactory.initialize();
        }
        if ((beanDesc = (BeanDesc)beanDescCache.get(clazz)) == null) {
            beanDesc = new BeanDescImpl(clazz);
            beanDescCache.put(clazz, beanDesc);
        }
        return beanDesc;
    }

    public static void initialize() {
        DisposableUtil.add(new Disposable(){

            public void dispose() {
                BeanDescFactory.clear();
            }
        });
        initialized = true;
    }

    public static void clear() {
        beanDescCache.clear();
        initialized = false;
    }

    static {
        beanDescCache = MapUtil.createHashMap(1024);
        BeanDescFactory.initialize();
    }
}

