/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import org.seasar.extension.jdbc.AutoProcedureCall;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoProcedureCallImpl
extends AbstractProcedureCall<AutoProcedureCall>
implements AutoProcedureCall {
    protected String procedureName;

    public AutoProcedureCallImpl(JdbcManagerImplementor jdbcManager, String procedureName) {
        this(jdbcManager, procedureName, null);
    }

    public AutoProcedureCallImpl(JdbcManagerImplementor jdbcManager, String procedureName, Object param) {
        super(jdbcManager);
        if (procedureName == null) {
            throw new NullPointerException("procedureName");
        }
        this.procedureName = procedureName;
        this.parameter = param;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareParameter();
        this.prepareSql();
    }

    protected void prepareSql() {
        StringBuilder buf = new StringBuilder(100).append("{call ").append(this.procedureName);
        int paramSize = this.getParamSize();
        buf.append("(");
        if (paramSize > 0) {
            for (int i = 0; i < paramSize; ++i) {
                buf.append("?, ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        this.executedSql = new String(buf.append("}"));
    }
}

