/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.ClassUtil;

public abstract class DriverManagerUtil {
    public static void registerDriver(String driverClassName) {
        DriverManagerUtil.registerDriver(ClassUtil.forName(driverClassName));
    }

    public static void registerDriver(Class driverClass) {
        DriverManagerUtil.registerDriver((Driver)ClassUtil.newInstance(driverClass));
    }

    public static void registerDriver(Driver driver) {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    public static void deregisterDriver(Driver driver) {
        try {
            DriverManager.deregisterDriver(driver);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    public static synchronized void deregisterAllDrivers() {
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            DriverManagerUtil.deregisterDriver(e.nextElement());
        }
    }
}

