/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.action;

import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.spi.JsonProvider;
import org.seasar.cubby.spi.ProviderFactory;

public class Json
implements ActionResult {
    private final Object bean;
    private final JsonProvider jsonProvider;
    private final String calllback;
    private String contentType = "text/javascript";
    private String encoding = "utf-8";
    private boolean xjson = false;

    public Json(Object bean) {
        this(bean, null, ProviderFactory.get(JsonProvider.class));
    }

    public Json(Object bean, JsonProvider jsonProvider) {
        this(bean, null, jsonProvider);
    }

    public Json(Object bean, String callback) {
        this(bean, callback, ProviderFactory.get(JsonProvider.class));
    }

    public Json(Object bean, String callback, JsonProvider jsonProvider) {
        if (jsonProvider == null) {
            throw new NullPointerException("jsonProvider");
        }
        this.bean = bean;
        this.calllback = callback;
        this.jsonProvider = jsonProvider;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getCallback() {
        return this.calllback;
    }

    public Json contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Json encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void xjson() {
        this.xjson = true;
    }

    public boolean isXjson() {
        return this.xjson;
    }

    public void execute(ActionContext actionContext, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setCharacterEncoding(this.encoding);
        response.setContentType(this.contentType + "; charset=" + this.encoding);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        String script = this.isJsonp() ? Json.appendCallbackFunction(this.jsonProvider.toJson(this.bean), this.calllback) : this.jsonProvider.toJson(this.bean);
        if (this.xjson) {
            response.setHeader("X-JSON", script);
        } else {
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write(script);
            ((Writer)writer).flush();
        }
    }

    private boolean isJsonp() {
        return !StringUtils.isEmpty(this.calllback);
    }

    private static String appendCallbackFunction(String script, String callback) {
        StringBuilder builder = new StringBuilder(script.length() + callback.length() + 10);
        builder.append(callback);
        builder.append("(");
        builder.append(script);
        builder.append(");");
        return builder.toString();
    }
}

