/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.scope.PageScope;
import org.seasar.teeda.core.render.Base64EncodeConverter;
import org.seasar.teeda.core.util.JavaScriptPermissionUtil;
import org.seasar.teeda.extension.component.UIBody;
import org.seasar.teeda.extension.render.RendererListener;
import org.seasar.teeda.extension.render.TBodyRenderer;

public class ConditionUtil {
    public static final String KEY = "org.seasar.teeda.extension.Condition";

    public static Boolean getCondition(FacesContext context, String clientId) {
        Map conditions = ConditionUtil.getConditions(context);
        if (conditions == null) {
            return null;
        }
        return (Boolean)conditions.get(clientId);
    }

    public static void addCondition(FacesContext context, String clientId, boolean value) {
        Map conditions = ConditionUtil.getOrCreateConditions(context);
        conditions.put(clientId, value);
    }

    public static Boolean removeCondition(FacesContext context, String clientId) {
        Map conditions = ConditionUtil.getConditions(context);
        if (conditions == null) {
            return null;
        }
        return (Boolean)conditions.remove(clientId);
    }

    public static Map getConditions(FacesContext context) {
        Map map = PageScope.getContext((FacesContext)context);
        if (map == null) {
            return null;
        }
        return (Map)map.get(KEY);
    }

    public static Map getOrCreateConditions(FacesContext context) {
        Map map = PageScope.getOrCreateContext((FacesContext)context);
        LinkedHashMap conditions = (LinkedHashMap)map.get(KEY);
        if (conditions == null) {
            conditions = new LinkedHashMap(128);
            map.put(KEY, conditions);
        }
        return conditions;
    }

    public static void setConditions(FacesContext context, Map conditions) {
        Map map = PageScope.getOrCreateContext((FacesContext)context);
        map.put(KEY, conditions);
    }

    public static void removeConditions(FacesContext context) {
        Map map = PageScope.getContext((FacesContext)context);
        if (map != null) {
            map.remove(KEY);
        }
    }

    public static List getForms(FacesContext context) {
        Map map = context.getExternalContext().getRequestMap();
        List forms = (List)map.get(KEY);
        return forms;
    }

    public static void addForm(FacesContext context, UIForm form) {
        Map map = context.getExternalContext().getRequestMap();
        ArrayList<String> forms = (ArrayList<String>)map.get(KEY);
        if (forms == null) {
            forms = new ArrayList<String>();
            map.put(KEY, forms);
            ConditionUtil.registerRendererListener(form.getParent());
        }
        forms.add(context.getExternalContext().encodeNamespace(form.getId()));
    }

    protected static void registerRendererListener(UIComponent component) {
        while (component != null) {
            if (component instanceof UIBody) {
                TBodyRenderer.addRendererListener((UIBody)component, new ConditionRendererListener());
                break;
            }
            component = component.getParent();
        }
    }

    public static class ConditionRendererListener
    implements RendererListener {
        public void renderBeforeBodyEnd(FacesContext context) throws IOException {
            if (!JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)context)) {
                return;
            }
            Map conditions = ConditionUtil.getConditions(context);
            if (conditions == null || conditions.isEmpty()) {
                return;
            }
            List forms = ConditionUtil.getForms(context);
            if (forms == null || forms.isEmpty()) {
                return;
            }
            ConditionRendererListener.renderJavascript(context.getResponseWriter(), conditions, forms);
        }

        protected static void renderJavascript(ResponseWriter writer, Map conditions, List forms) throws IOException {
            writer.write("\n");
            writer.startElement("script", null);
            writer.writeAttribute("language", (Object)"JavaScript", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("\n");
            writer.write("<!--");
            writer.write("\n");
            writer.write("var forms = [");
            for (int i = 0; i < forms.size(); ++i) {
                String form = (String)forms.get(i);
                writer.write("'");
                writer.write(form);
                writer.write("'");
                if (i >= forms.size() - 1) continue;
                writer.write(", ");
            }
            writer.write("];");
            writer.write("\n");
            writer.write("for (var i = 0, len = forms.length; i < len; ++i) {");
            writer.write("\n");
            writer.write("  var span = document.createElement('span');");
            writer.write("\n");
            writer.write("  span.style.display = 'none';");
            writer.write("\n");
            writer.write("  span.style.position = 'absolute';");
            writer.write("\n");
            writer.write("  var form = document.getElementById(forms[i]);");
            writer.write("\n");
            writer.write("  form.appendChild(span);");
            writer.write("\n");
            writer.write("  span.innerHTML = \"<input type='hidden' name='");
            writer.write("te-conditions");
            writer.write("' value='");
            Base64EncodeConverter converter = new Base64EncodeConverter();
            String value = converter.getAsEncodeString((Object)conditions);
            writer.write(value);
            writer.write("' />\";");
            writer.write("\n");
            writer.write("}");
            writer.write("\n");
            writer.write("\n");
            writer.write("//-->");
            writer.write("\n");
            writer.endElement("script");
        }
    }
}

