/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.log.Logger;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.teeda.core.mock.MockApplicationMap;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.mock.MockServletRequestParameterMap;
import org.seasar.teeda.core.mock.MockServletRequestParameterValuesMap;
import org.seasar.teeda.core.mock.MockSessionMap;

public class MockExternalContextImpl
extends MockExternalContext {
    private static final Logger logger_ = Logger.getLogger((Class)MockExternalContextImpl.class);
    private MockServletContext mockServletContext_;
    private MockHttpServletRequest mockHttpServletRequest_;
    private MockHttpServletResponse mockHttpServletResponse_;
    private Map applicationMap_;
    private Map requestParameterMap_;
    private Map requestCookieMap_ = new HashMap();
    private Map requestHeaderMap_ = new HashMap();
    private Map sessionMap_;
    private Map requestMap_;
    private Map requestParameterValuesMap_;
    private String pathInfo;

    public MockExternalContextImpl() {
    }

    public MockExternalContextImpl(MockServletContext context, MockHttpServletRequest request, MockHttpServletResponse response) {
        this.mockServletContext_ = context;
        this.mockHttpServletRequest_ = request;
        this.mockHttpServletResponse_ = response;
        this.applicationMap_ = new MockApplicationMap((ServletContext)this.mockServletContext_);
    }

    public void addRequestCookieMap(Cookie cookie) {
        this.requestCookieMap_.put(cookie.getName(), cookie);
    }

    public void setRequestCookieMap(Map map) {
        this.requestParameterMap_ = map;
    }

    public void addRequestParameterMap(String key, String value) {
        this.requestParameterMap_.put(key, value);
    }

    public void setRequestParameterMap(Map map) {
        this.requestParameterMap_ = map;
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"dispatch called.");
        }
    }

    public String encodeActionURL(String sb) {
        return this.getMockHttpServletResponse().encodeURL(sb);
    }

    public String encodeNamespace(String aValue) {
        return aValue;
    }

    public String encodeResourceURL(String url) {
        return this.getMockHttpServletResponse().encodeURL(url);
    }

    public Map getApplicationMap() {
        if (this.applicationMap_ == null) {
            this.applicationMap_ = new HashMap();
        }
        return this.applicationMap_;
    }

    public String getAuthType() {
        return this.getMockHttpServletRequest().getAuthType();
    }

    public Object getContext() {
        return this.getMockServletContext();
    }

    public MockServletContext getMockServletContext() {
        if (this.mockServletContext_ == null) {
            this.mockServletContext_ = new MockServletContextImpl("/mock-context");
        }
        return this.mockServletContext_;
    }

    public void setMockServletContext(MockServletContext mockServletContext) {
        this.mockServletContext_ = mockServletContext;
    }

    public String getInitParameter(String name) {
        return this.getMockServletContext().getInitParameter(name);
    }

    public Map getInitParameterMap() {
        return this.getMockServletContext().getInitParameterMap();
    }

    public String getRemoteUser() {
        return this.getMockHttpServletRequest().getRemoteUser();
    }

    public Object getRequest() {
        return this.getMockHttpServletRequest();
    }

    public MockHttpServletRequest getMockHttpServletRequest() {
        if (this.mockHttpServletRequest_ == null) {
            this.mockHttpServletRequest_ = new MockHttpServletRequestImpl((ServletContext)this.getMockServletContext(), "/mock-path.html");
        }
        return this.mockHttpServletRequest_;
    }

    public void setMockHttpServletRequest(MockHttpServletRequest mockHttpServletRequest) {
        this.mockHttpServletRequest_ = mockHttpServletRequest;
    }

    public String getRequestContextPath() {
        return this.getMockHttpServletRequest().getContextPath();
    }

    public Map getRequestCookieMap() {
        return this.requestCookieMap_;
    }

    public Map getRequestHeaderMap() {
        return this.requestHeaderMap_;
    }

    public Map getRequestHeaderValuesMap() {
        throw new UnsupportedOperationException();
    }

    public Locale getRequestLocale() {
        return this.getMockHttpServletRequest().getLocale();
    }

    public Iterator getRequestLocales() {
        return new LocalesIterator(this.getMockHttpServletRequest().getLocales());
    }

    public Map getRequestMap() {
        if (this.requestMap_ == null) {
            this.requestMap_ = new HashMap();
        }
        return this.requestMap_;
    }

    public Map getRequestParameterMap() {
        if (this.requestParameterMap_ == null) {
            this.requestParameterMap_ = new MockServletRequestParameterMap(this.getMockHttpServletRequest());
        }
        return this.requestParameterMap_;
    }

    public Iterator getRequestParameterNames() {
        throw new UnsupportedOperationException();
    }

    public Map getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap_ == null) {
            this.requestParameterValuesMap_ = new MockServletRequestParameterValuesMap(this.getMockHttpServletRequest());
        }
        return this.requestParameterValuesMap_;
    }

    public String getRequestPathInfo() {
        if (this.pathInfo != null) {
            return this.pathInfo;
        }
        return this.getMockHttpServletRequest().getPathInfo();
    }

    public void setRequestPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getRequestServletPath() {
        return this.getMockHttpServletRequest().getServletPath();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.getMockServletContext().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getMockServletContext().getResourceAsStream(path);
    }

    public Set getResourcePaths(String path) {
        return this.getMockServletContext().getResourcePaths(path);
    }

    public Object getResponse() {
        return this.getMockHttpServletResponse();
    }

    public MockHttpServletResponse getMockHttpServletResponse() {
        if (this.mockHttpServletResponse_ == null) {
            this.mockHttpServletResponse_ = new MockHttpServletResponseImpl((HttpServletRequest)this.getMockHttpServletRequest());
        }
        return this.mockHttpServletResponse_;
    }

    public void setMockHttpServletResponse(MockHttpServletResponse mockHttpServletResponse) {
        this.mockHttpServletResponse_ = mockHttpServletResponse;
    }

    public Object getSession(boolean create) {
        return this.getMockHttpServletRequest().getSession(create);
    }

    public Map getSessionMap() {
        if (this.sessionMap_ == null) {
            HttpSession session = this.getMockHttpServletRequest().getSession(true);
            this.sessionMap_ = new MockSessionMap(session);
        }
        return this.sessionMap_;
    }

    public Principal getUserPrincipal() {
        return this.getMockHttpServletRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getMockHttpServletRequest().isUserInRole(role);
    }

    public void log(String message) {
        this.getMockServletContext().log(message);
    }

    public void log(String message, Throwable throwable) {
        this.getMockServletContext().log(message, throwable);
    }

    public void redirect(String requestURI) throws IOException {
        this.getMockHttpServletResponse().sendRedirect(requestURI);
    }

    private static class LocalesIterator
    implements Iterator {
        private Enumeration locales;

        public LocalesIterator(Enumeration locales) {
            this.locales = locales;
        }

        public boolean hasNext() {
            return this.locales.hasMoreElements();
        }

        public Object next() {
            return this.locales.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

