/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.annotation.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.internal.EnumUtil;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.tiger.AnnotationUtil;
import org.seasar.teeda.extension.annotation.handler.ConstantValidatorAnnotationHandler;
import org.seasar.teeda.extension.annotation.validator.Validator;

public class TigerValidatorAnnotationHandler
extends ConstantValidatorAnnotationHandler {
    protected Class<? extends Annotation> metaAnnotationType = Validator.class;

    protected void processProperty(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, PropertyDesc propertyDesc, Field[] fields) {
        Field field = propertyDesc.getField();
        if (field != null) {
            this.processField(container, componentName, field);
        }
        if (propertyDesc.hasWriteMethod()) {
            this.processSetterMethod(container, componentName, propertyDesc);
        }
        super.processProperty(container, componentClass, componentName, namingConvention, propertyDesc, fields);
    }

    protected void processField(S2Container container, String componentName, Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            this.processAnnotation(container, componentName, field.getName(), annotation);
        }
    }

    protected void processAnnotation(S2Container container, String componentName, String propertyName, Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Annotation metaAnnotation = annotationType.getAnnotation(this.metaAnnotationType);
        if (metaAnnotation == null) {
            return;
        }
        String validatorName = this.getValidatorName(metaAnnotation);
        Map props = AnnotationUtil.getProperties((Annotation)annotation);
        if (HotdeployUtil.isHotdeploy()) {
            props = EnumUtil.convertEnumToName((Map)props);
        }
        this.registerValidator(componentName, propertyName, validatorName, props);
    }

    protected void processSetterMethod(S2Container container, String componentName, PropertyDesc propertyDesc) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = propertyDesc.getWriteMethod().getDeclaredAnnotations()) {
            this.processAnnotation(container, componentName, propertyDesc.getPropertyName(), annotation);
        }
    }

    protected String getValidatorName(Annotation annotation) {
        Class<? extends Annotation> annoType = annotation.annotationType();
        Method m = ClassUtil.getMethod(annoType, (String)"value", null);
        return (String)MethodUtil.invoke((Method)m, (Object)annotation, null);
    }
}

