/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.util.FacesContextUtil;

public class StateManagerUtil {
    private StateManagerUtil() {
    }

    public static boolean isSavingStateInClient(FacesContext context) {
        return FacesContextUtil.getStateManager(context).isSavingStateInClient(context);
    }

    public static void assertComponentNoDuplicateId(UIComponent component) {
        StateManagerUtil.assertComponentNoDuplicateIdInternal(component, new ArrayList());
    }

    private static void assertComponentNoDuplicateIdInternal(UIComponent component, List idList) {
        String id = component.getId();
        if (id != null && idList.contains(id)) {
            throw new IllegalStateException("Component id:" + id + " has same id in view tree.");
        }
        idList.add(id);
        Iterator itr = component.getFacetsAndChildren();
        while (itr.hasNext()) {
            UIComponent child = (UIComponent)itr.next();
            if (component instanceof NamingContainer) {
                StateManagerUtil.assertComponentNoDuplicateId(child);
                continue;
            }
            StateManagerUtil.assertComponentNoDuplicateIdInternal(child, idList);
        }
    }
}

