/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.util.FileUtils;
import org.h2.util.StringUtils;

public class TraceObject {
    public static final int CALLABLE_STATEMENT = 0;
    public static final int CONNECTION = 1;
    public static final int DATABASE_META_DATA = 2;
    public static final int PREPARED_STATEMENT = 3;
    public static final int RESULT_SET = 4;
    public static final int RESULT_SET_META_DATA = 5;
    public static final int SAVEPOINT = 6;
    public static final int SQL_EXCEPTION = 7;
    public static final int STATEMENT = 8;
    public static final int BLOB = 9;
    public static final int CLOB = 10;
    public static final int PARAMETER_META_DATA = 11;
    public static final int DATA_SOURCE = 12;
    public static final int XA_DATA_SOURCE = 13;
    public static final int XID = 14;
    public static final int ARRAY = 15;
    private static final int LAST = 16;
    private Trace trace;
    private static final int[] ID = new int[16];
    private static final String[] PREFIX = new String[]{"call", "conn", "dbMeta", "prep", "rs", "rsMeta", "sp", "ex", "stat", "blob", "clob", "pMeta", "ds", "xads", "xid", "ar"};
    private int type;
    private int id;

    protected void setTrace(Trace trace, int type, int id) {
        this.trace = trace;
        this.type = type;
        this.id = id;
    }

    protected int getTraceId() {
        return this.id;
    }

    public String toString() {
        return PREFIX[this.type] + this.id;
    }

    protected int getNextId(int type) {
        int n = type;
        int n2 = ID[n];
        ID[n] = n2 + 1;
        return n2;
    }

    protected boolean debug() {
        return this.trace.debug();
    }

    protected boolean info() {
        return this.trace.info();
    }

    protected Trace getTrace() {
        return this.trace;
    }

    protected void debugCodeAssign(String className, int type, int id) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(className + " " + PREFIX[type] + id + " = ");
    }

    protected void infoCodeAssign(String className, int type, int id) {
        if (!this.trace.info()) {
            return;
        }
        this.trace.infoCode(className + " " + PREFIX[type] + id + " = ");
    }

    protected void debugCodeCall(String text) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(this.toString() + "." + text + "();");
    }

    protected void debugCodeCall(String text, long param) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(this.toString() + "." + text + "(" + param + ");");
    }

    protected void debugCodeCall(String text, String param) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(this.toString() + "." + text + "(" + this.quote(param) + ");");
    }

    protected void debugCode(String text) {
        if (!this.trace.debug()) {
            return;
        }
        this.trace.debugCode(this.toString() + "." + text);
    }

    protected String quote(String s) {
        return StringUtils.quoteJavaString(s);
    }

    protected String quoteTime(Time x) {
        if (x == null) {
            return "null";
        }
        return "Time.valueOf(\"" + x.toString() + "\")";
    }

    protected String quoteTimestamp(Timestamp x) {
        if (x == null) {
            return "null";
        }
        return "Timestamp.valueOf(\"" + x.toString() + "\")";
    }

    protected String quoteDate(Date x) {
        if (x == null) {
            return "null";
        }
        return "Date.valueOf(\"" + x.toString() + "\")";
    }

    protected String quoteBigDecimal(BigDecimal x) {
        if (x == null) {
            return "null";
        }
        return "new BigDecimal(\"" + x.toString() + "\")";
    }

    protected String quoteBytes(byte[] x) {
        if (x == null) {
            return "null";
        }
        return "new byte[" + x.length + "]";
    }

    protected String quoteArray(String[] s) {
        return StringUtils.quoteJavaStringArray(s);
    }

    protected String quoteIntArray(int[] s) {
        return StringUtils.quoteJavaIntArray(s);
    }

    protected String quoteMap(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "new Map()";
        }
        StringBuffer buff = new StringBuffer("new Map() /* ");
        try {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                buff.append(key);
                buff.append(':');
                Class clazz = (Class)entry.getValue();
                buff.append(clazz.getName());
            }
        }
        catch (Exception e) {
            buff.append(e.toString() + ": " + map.toString());
        }
        buff.append("*/");
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLException logAndConvert(Throwable e) {
        if (SysProperties.LOG_ALL_ERRORS) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                try {
                    FileWriter writer = FileUtils.openFileWriter(SysProperties.LOG_ALL_ERRORS_FILE, true);
                    PrintWriter p = new PrintWriter(writer);
                    e.printStackTrace(p);
                    p.close();
                    ((Writer)writer).close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        if (this.trace == null) {
            TraceSystem.traceThrowable(e);
        } else {
            if (e instanceof SQLException) {
                this.trace.error("SQLException", e);
                return (SQLException)e;
            }
            this.trace.error("Uncaught Exception", e);
        }
        return Message.convert(e);
    }
}

