/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.timer.TimerFactory;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Dependency;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;

final class GenericStatementContext
extends ContextImpl
implements StatementContext {
    private boolean setSavePoint;
    private String internalSavePointName;
    private ResultSet topResultSet;
    private ArrayList dependencies;
    private NoPutResultSet[] subqueryTrackingArray;
    private NoPutResultSet[] materializedSubqueries;
    private final LanguageConnectionContext lcc;
    private boolean inUse = true;
    private volatile boolean cancellationFlag = false;
    private CancelQueryTask cancelTask = null;
    private boolean parentInTrigger;
    private boolean isForReadOnly = false;
    private boolean isAtomic;
    private boolean isSystemCode;
    private boolean rollbackParentContext;
    private String stmtText;
    private ParameterValueSet pvs;
    private short sqlAllowed = (short)-1;

    GenericStatementContext(LanguageConnectionContext languageConnectionContext) {
        super(languageConnectionContext.getContextManager(), "StatementContext");
        this.lcc = languageConnectionContext;
        this.internalSavePointName = "ISSP" + this.hashCode();
    }

    public void setInUse(boolean bl, boolean bl2, boolean bl3, String string, ParameterValueSet parameterValueSet, long l) {
        this.inUse = true;
        this.parentInTrigger = bl;
        this.isForReadOnly = bl3;
        this.isAtomic = bl2;
        this.stmtText = string;
        this.pvs = parameterValueSet;
        this.rollbackParentContext = false;
        if (l > 0L) {
            TimerFactory timerFactory = Monitor.getMonitor().getTimerFactory();
            Timer timer = timerFactory.getCancellationTimer();
            this.cancelTask = new CancelQueryTask(this);
            timer.schedule((TimerTask)this.cancelTask, l);
        }
    }

    public void clearInUse() {
        this.stuffTopResultSet(null, null);
        this.inUse = false;
        this.parentInTrigger = false;
        this.isAtomic = false;
        this.isForReadOnly = false;
        this.stmtText = null;
        this.sqlAllowed = (short)-1;
        this.isSystemCode = false;
        this.rollbackParentContext = false;
        if (this.cancelTask != null) {
            this.cancelTask.forgetContext();
            this.cancelTask = null;
        }
        this.cancellationFlag = false;
    }

    public void setSavePoint() throws StandardException {
        this.pleaseBeOnStack();
        this.lcc.getTransactionExecute().setSavePoint(this.internalSavePointName, null);
        this.setSavePoint = true;
    }

    public void resetSavePoint() throws StandardException {
        if (this.inUse && this.setSavePoint) {
            this.lcc.getTransactionExecute().setSavePoint(this.internalSavePointName, null);
        }
    }

    public void clearSavePoint() throws StandardException {
        this.pleaseBeOnStack();
        this.lcc.getTransactionExecute().releaseSavePoint(this.internalSavePointName, null);
        this.setSavePoint = false;
    }

    public void setTopResultSet(ResultSet resultSet, NoPutResultSet[] noPutResultSetArray) throws StandardException {
        this.pleaseBeOnStack();
        if (this.materializedSubqueries != null) {
            if (noPutResultSetArray != null) {
                for (int i = 0; i < noPutResultSetArray.length; ++i) {
                    if (this.subqueryTrackingArray[i] == null) continue;
                    noPutResultSetArray[i] = this.materializedSubqueries[i];
                }
            } else {
                noPutResultSetArray = this.materializedSubqueries;
            }
            this.materializedSubqueries = null;
        }
        this.stuffTopResultSet(resultSet, noPutResultSetArray);
    }

    private void stuffTopResultSet(ResultSet resultSet, NoPutResultSet[] noPutResultSetArray) {
        this.topResultSet = resultSet;
        this.subqueryTrackingArray = noPutResultSetArray;
        this.dependencies = null;
    }

    public void setSubqueryResultSet(int n, NoPutResultSet noPutResultSet, int n2) throws StandardException {
        this.pleaseBeOnStack();
        if (this.subqueryTrackingArray == null) {
            if (this.topResultSet == null) {
                this.subqueryTrackingArray = new NoPutResultSet[n2];
                this.materializedSubqueries = new NoPutResultSet[n2];
            } else {
                this.subqueryTrackingArray = this.topResultSet.getSubqueryTrackingArray(n2);
            }
        }
        this.subqueryTrackingArray[n] = noPutResultSet;
        if (this.materializedSubqueries != null) {
            this.materializedSubqueries[n] = noPutResultSet;
        }
    }

    public NoPutResultSet[] getSubqueryTrackingArray() throws StandardException {
        this.pleaseBeOnStack();
        return this.subqueryTrackingArray;
    }

    public void addDependency(Dependency dependency) throws StandardException {
        this.pleaseBeOnStack();
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        this.dependencies.add(dependency);
    }

    public boolean inTrigger() {
        return this.parentInTrigger;
    }

    public void cleanupOnError(Throwable throwable) throws StandardException {
        int n;
        int n2 = n = throwable instanceof StandardException ? ((StandardException)throwable).getSeverity() : 40000;
        if (!this.inUse) {
            return;
        }
        if (this.topResultSet != null) {
            this.topResultSet.cleanUp();
        }
        if (this.subqueryTrackingArray != null) {
            for (int i = 0; i < this.subqueryTrackingArray.length; ++i) {
                if (this.subqueryTrackingArray[i] == null) continue;
                this.subqueryTrackingArray[i].cleanUp();
            }
        }
        if (this.dependencies != null) {
            DependencyManager dependencyManager = this.lcc.getDataDictionary().getDependencyManager();
            Iterator iterator = this.dependencies.iterator();
            while (iterator.hasNext()) {
                Dependency dependency = (Dependency)iterator.next();
                dependencyManager.clearInMemoryDependency(dependency);
            }
            this.dependencies = null;
        }
        if (n <= 20000 && this.setSavePoint) {
            this.lcc.internalRollbackToSavepoint(this.internalSavePointName, false, null);
            this.clearSavePoint();
        }
        if (n >= 30000) {
            this.setSavePoint = false;
        }
        this.lcc.popStatementContext(this, throwable);
    }

    public boolean isLastHandler(int n) {
        return this.inUse && !this.rollbackParentContext && n == 20000;
    }

    public boolean onStack() {
        return this.inUse;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    public String getStatementText() {
        return this.stmtText;
    }

    private void pleaseBeOnStack() throws StandardException {
        if (!this.inUse) {
            throw StandardException.newException("40XC0");
        }
    }

    public boolean inUse() {
        return this.inUse;
    }

    public boolean isForReadOnly() {
        return this.isForReadOnly;
    }

    public boolean isCancelled() {
        return this.cancellationFlag;
    }

    public void cancel() {
        this.cancellationFlag = true;
    }

    public void setSQLAllowed(short s, boolean bl) {
        if (bl || s > this.sqlAllowed) {
            this.sqlAllowed = s;
        }
    }

    public short getSQLAllowed() {
        if (!this.inUse) {
            return 3;
        }
        return this.sqlAllowed;
    }

    public void setParentRollback() {
        this.rollbackParentContext = true;
    }

    public void setSystemCode() {
        this.isSystemCode = true;
    }

    public boolean getSystemCode() {
        return this.isSystemCode;
    }

    public StringBuffer appendErrorInfo() {
        StringBuffer stringBuffer = ((ContextImpl)((Object)this.lcc)).appendErrorInfo();
        if (stringBuffer != null) {
            stringBuffer.append("Failed Statement is: ");
            stringBuffer.append(this.getStatementText());
            if (this.pvs != null && this.pvs.getParameterCount() > 0) {
                String string = " with " + this.pvs.getParameterCount() + " parameters " + this.pvs.toString();
                stringBuffer.append(string);
            }
        }
        return stringBuffer;
    }

    private static class CancelQueryTask
    extends TimerTask {
        private StatementContext statementContext;

        public CancelQueryTask(StatementContext statementContext) {
            this.statementContext = statementContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CancelQueryTask cancelQueryTask = this;
            synchronized (cancelQueryTask) {
                if (this.statementContext != null) {
                    this.statementContext.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forgetContext() {
            boolean bl;
            boolean bl2 = bl = !this.cancel();
            if (bl) {
                CancelQueryTask cancelQueryTask = this;
                synchronized (cancelQueryTask) {
                    this.statementContext = null;
                }
            }
        }
    }
}

