/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.FontInfo;
import org.apache.fop.configuration.FontTriplet;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationParser
extends DefaultHandler {
    private static final int OUT = 0;
    private static final int IN_ENTRY = 1;
    private static final int IN_KEY = 2;
    private static final int IN_VALUE = 4;
    private static final int IN_LIST = 8;
    private static final int IN_SUBENTRY = 16;
    private static final int IN_SUBKEY = 32;
    private static final int IN_FONTS = 64;
    private static final int IN_FONT = 128;
    private static final int STRING = 0;
    private static final int LIST = 1;
    private static final int MAP = 2;
    private int status = 0;
    private int datatype = -1;
    private static Map configuration;
    private static Map activeConfiguration;
    private String key = "";
    private List keyStack = new ArrayList();
    private String value = "";
    private String subkey = "";
    private List list = new ArrayList(15);
    private Map map = new HashMap(15);
    private Locator locator;
    private String role = "standard";
    private List fontList = null;
    private FontInfo fontInfo = null;
    private FontTriplet fontTriplet = null;
    private String fontName;
    private String metricsFile;
    private String embedFile;
    private String kerningAsString;
    private boolean kerning;
    private List fontTriplets;
    private String fontTripletName;
    private String weight;
    private String style;

    public void characters(char[] ch, int start, int length) {
        char[] characters = new char[length];
        System.arraycopy(ch, start, characters, 0, length);
        String text = new String(characters);
        switch (this.status) {
            case 2: {
                this.key = text;
                break;
            }
            case 26: {
                this.subkey = text;
                break;
            }
            case 4: {
                this.value = text;
                this.datatype = 0;
                break;
            }
            case 12: {
                this.list.add(text);
                this.datatype = 1;
                break;
            }
            case 28: {
                this.value = text;
                this.datatype = 2;
                break;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("entry")) {
            switch (this.datatype) {
                case 0: {
                    this.store(this.role, this.key, this.value);
                    break;
                }
                case 1: {
                    this.store(this.role, this.key, this.list);
                    break;
                }
                case 2: {
                    this.store(this.role, this.key, this.map);
                }
            }
            this.status = 0;
            this.role = "standard";
            if (this.keyStack.size() > 0) {
                this.keyStack.remove(this.keyStack.size() - 1);
            }
            this.key = this.keyStack.size() > 0 ? (String)this.keyStack.get(this.keyStack.size() - 1) : "";
            this.value = "";
        } else if (localName.equals("subentry")) {
            this.map.put(this.subkey, this.value);
            this.status -= 16;
            if (this.keyStack.size() > 0) {
                this.keyStack.remove(this.keyStack.size() - 1);
            }
            this.key = this.keyStack.size() > 0 ? (String)this.keyStack.get(this.keyStack.size() - 1) : "";
            this.value = "";
        } else if (localName.equals("key")) {
            this.status -= 2;
            this.keyStack.add(this.key);
        } else if (localName.equals("list")) {
            this.status -= 8;
            this.value = "";
        } else if (localName.equals("value")) {
            this.status -= 4;
        } else if (localName.equals("fonts")) {
            this.store("standard", "fonts", this.fontList);
        } else if (localName.equals("font")) {
            this.fontInfo = new FontInfo(this.fontName, this.metricsFile, this.kerning, this.fontTriplets, this.embedFile);
            this.fontList.add(this.fontInfo);
            this.fontTriplets = null;
            this.metricsFile = null;
            this.embedFile = null;
            this.fontName = null;
            this.kerningAsString = "";
        } else {
            localName.equals("font-triplet");
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() {
        configuration = Configuration.getConfiguration();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equals("key")) {
            this.status += 2;
        } else if (localName.equals("value")) {
            this.status += 4;
        } else if (localName.equals("list")) {
            this.status += 8;
        } else if (localName.equals("subentry")) {
            this.status += 16;
        } else if (localName.equals("entry")) {
            this.role = attributes.getLength() == 0 ? "standard" : attributes.getValue("role");
        } else if (!localName.equals("configuration")) {
            if (localName.equals("fonts")) {
                this.fontList = new ArrayList(10);
            } else if (localName.equals("font")) {
                this.kerningAsString = attributes.getValue("kerning");
                this.kerning = this.kerningAsString.equalsIgnoreCase("yes");
                this.metricsFile = attributes.getValue("metrics-file");
                this.embedFile = attributes.getValue("embed-file");
                this.fontName = attributes.getValue("name");
                this.fontTriplets = new ArrayList(5);
            } else if (localName.equals("font-triplet")) {
                this.fontTripletName = attributes.getValue("name");
                this.weight = attributes.getValue("weight");
                this.style = attributes.getValue("style");
                this.fontTriplet = new FontTriplet(this.fontTripletName, this.weight, this.style);
                this.fontTriplets.add(this.fontTriplet);
            } else {
                MessageHandler.errorln("Unknown tag in configuration file: " + localName);
            }
        }
    }

    private void store(String role, String key, Object value) {
        activeConfiguration = (Map)configuration.get(role);
        if (activeConfiguration != null) {
            activeConfiguration.put(key, value);
        } else {
            MessageHandler.errorln("Unknown role >" + role + "< for new configuration entry. \n" + "Putting configuration with key:" + key + " into standard configuration.");
        }
    }
}

