/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout.hyphenation;

import java.io.Serializable;

public class ByteVector
implements Serializable {
    private static final int DEFAULT_BLOCK_SIZE = 2048;
    private int BLOCK_SIZE;
    private byte[] array;
    private int n;

    public ByteVector() {
        this(2048);
    }

    public ByteVector(int capacity) {
        this.BLOCK_SIZE = capacity > 0 ? capacity : 2048;
        this.array = new byte[this.BLOCK_SIZE];
        this.n = 0;
    }

    public ByteVector(byte[] a) {
        this.BLOCK_SIZE = 2048;
        this.array = a;
        this.n = 0;
    }

    public ByteVector(byte[] a, int capacity) {
        this.BLOCK_SIZE = capacity > 0 ? capacity : 2048;
        this.array = a;
        this.n = 0;
    }

    public int alloc(int size) {
        int index = this.n;
        int len = this.array.length;
        if (this.n + size >= len) {
            byte[] aux = new byte[len + this.BLOCK_SIZE];
            System.arraycopy(this.array, 0, aux, 0, len);
            this.array = aux;
        }
        this.n += size;
        return index;
    }

    public int capacity() {
        return this.array.length;
    }

    public byte get(int index) {
        return this.array[index];
    }

    public byte[] getArray() {
        return this.array;
    }

    public int length() {
        return this.n;
    }

    public void put(int index, byte val) {
        this.array[index] = val;
    }

    public void trimToSize() {
        if (this.n < this.array.length) {
            byte[] aux = new byte[this.n];
            System.arraycopy(this.array, 0, aux, 0, this.n);
            this.array = aux;
        }
    }
}

