/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.TriggerObject;
import org.h2.table.Table;

public class CreateTrigger
extends SchemaCommand {
    private String triggerName;
    private boolean ifNotExists;
    private boolean before;
    private int typeMask;
    private boolean rowBased;
    private int queueSize = 1024;
    private boolean noWait;
    private String tableName;
    private String triggerClassName;

    public CreateTrigger(Session session, Schema schema) {
        super(session, schema);
    }

    public void setBefore(boolean before) {
        this.before = before;
    }

    public void setTriggerClassName(String triggerClassName) {
        this.triggerClassName = triggerClassName;
    }

    public void setTypeMask(int typeMask) {
        this.typeMask = typeMask;
    }

    public void setRowBased(boolean rowBased) {
        this.rowBased = rowBased;
    }

    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTriggerName(String name) {
        this.triggerName = name;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (this.getSchema().findTrigger(this.triggerName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90041, this.triggerName);
        }
        int id = this.getObjectId(false, true);
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        TriggerObject trigger = new TriggerObject(this.getSchema(), id, this.triggerName, table);
        trigger.setBefore(this.before);
        trigger.setNoWait(this.noWait);
        trigger.setQueueSize(this.queueSize);
        trigger.setRowBased(this.rowBased);
        trigger.setTriggerClassName(this.session, this.triggerClassName);
        trigger.setTypeMask(this.typeMask);
        db.addSchemaObject(this.session, trigger);
        table.addTrigger(trigger);
        return 0;
    }
}

