/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;

public class ContentType {
    private ParameterList _list;
    private String _minor;
    private String _major;

    public ContentType() {
        this("text", "plain", new ParameterList());
    }

    public ContentType(String major, String minor, ParameterList list) {
        this._major = major;
        this._minor = minor;
        this._list = list;
    }

    public ContentType(String type) throws ParseException {
        int slash = type.indexOf("/");
        int semi = type.indexOf(";");
        try {
            this._major = type.substring(0, slash);
            if (semi == -1) {
                this._minor = type.substring(slash + 1);
            } else {
                this._minor = type.substring(slash + 1, semi);
                this._list = new ParameterList(type.substring(semi + 1));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("Type invalid: " + type);
        }
    }

    public String getPrimaryType() {
        return this._major;
    }

    public String getSubType() {
        return this._minor;
    }

    public String getBaseType() {
        return this._major + "/" + this._minor;
    }

    public String getParameter(String name) {
        return this._list == null ? null : this._list.get(name);
    }

    public ParameterList getParameterList() {
        return this._list;
    }

    public void setPrimaryType(String major) {
        this._major = major;
    }

    public void setSubType(String minor) {
        this._minor = minor;
    }

    public void setParameter(String name, String value) {
        if (this._list == null) {
            this._list = new ParameterList();
        }
        this._list.set(name, value);
    }

    public void setParameterList(ParameterList list) {
        this._list = list;
    }

    public String toString() {
        return this.getBaseType() + (this._list == null ? "" : ";" + this._list.toString());
    }

    public boolean match(ContentType other) {
        return this._major.equals(other._major) && (this._minor.equals(other._minor) || this._minor.equals("*") || other._minor.equals("*"));
    }

    public boolean match(String contentType) {
        try {
            return this.match(new ContentType(contentType));
        }
        catch (ParseException e) {
            return false;
        }
    }
}

