/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;

public class Compare {
    private String referenceDirectory;
    private String testDirectory;
    private String[] filenameList;
    private String filenames;
    private static boolean IDENTICAL_FILES = true;
    private static boolean NOTIDENTICAL_FILES = false;
    private BufferedInputStream oldfileInput;
    private BufferedInputStream newfileInput;

    private boolean compareBytes(File oldFile, File newFile) {
        try {
            this.oldfileInput = new BufferedInputStream(new FileInputStream(oldFile));
            this.newfileInput = new BufferedInputStream(new FileInputStream(newFile));
            int charactO = 0;
            int charactN = 0;
            boolean identical = true;
            while (identical & charactO != -1) {
                if (charactO == charactN) {
                    charactO = this.oldfileInput.read();
                    charactN = this.newfileInput.read();
                    continue;
                }
                return NOTIDENTICAL_FILES;
            }
            return IDENTICAL_FILES;
        }
        catch (IOException io) {
            System.err.println("Task Compare - Error: \n" + io.toString());
            return NOTIDENTICAL_FILES;
        }
    }

    private boolean compareFileSize(File oldFile, File newFile) {
        if (oldFile.length() != newFile.length()) {
            return NOTIDENTICAL_FILES;
        }
        return IDENTICAL_FILES;
    }

    public void execute() throws BuildException {
        boolean identical = false;
        try {
            PrintWriter results = new PrintWriter((Writer)new FileWriter("results.html"), true);
            this.writeHeader(results);
            int i = 0;
            while (i < this.filenameList.length) {
                File newFile;
                File oldFile = new File(String.valueOf(this.referenceDirectory) + this.filenameList[i]);
                if (this.filesExist(oldFile, newFile = new File(String.valueOf(this.testDirectory) + this.filenameList[i]))) {
                    identical = this.compareFileSize(oldFile, newFile);
                    if (identical) {
                        identical = this.compareBytes(oldFile, newFile);
                    }
                    if (!identical) {
                        System.out.println("Task Compare: \nFiles " + this.referenceDirectory + oldFile.getName() + " - " + this.testDirectory + newFile.getName() + " are *not* identical.");
                        results.println("<tr><td><a href='" + this.referenceDirectory + oldFile.getName() + "'>" + oldFile.getName() + "</a> </td><td> <a href='" + this.testDirectory + newFile.getName() + "'>" + newFile.getName() + "</a>" + " </td><td><font color='red'>No</font></td></tr>");
                    } else {
                        results.println("<tr><td><a href='" + this.referenceDirectory + oldFile.getName() + "'>" + oldFile.getName() + "</a> </td><td> <a href='" + this.testDirectory + newFile.getName() + "'>" + newFile.getName() + "</a>" + " </td><td>Yes</td></tr>");
                    }
                }
                ++i;
            }
            results.println("</table></html>");
        }
        catch (IOException ioe) {
            System.err.println("ERROR: " + ioe);
        }
    }

    private boolean filesExist(File oldFile, File newFile) {
        if (!oldFile.exists()) {
            System.err.println("Task Compare - ERROR: File " + this.referenceDirectory + oldFile.getName() + " doesn't exist!");
            return false;
        }
        if (!newFile.exists()) {
            System.err.println("Task Compare - ERROR: File " + this.testDirectory + newFile.getName() + " doesn't exist!");
            return false;
        }
        return true;
    }

    public void setFilenames(String filenames) {
        StringTokenizer tokens = new StringTokenizer(filenames, ",");
        ArrayList<String> filenameListTmp = new ArrayList<String>(20);
        while (tokens.hasMoreTokens()) {
            filenameListTmp.add(tokens.nextToken());
        }
        this.filenameList = new String[filenameListTmp.size()];
        this.filenameList = filenameListTmp.toArray(this.filenameList);
    }

    public void setReferenceDirectory(String referenceDirectory) {
        if (!(referenceDirectory.endsWith("/") | referenceDirectory.endsWith("\\"))) {
            referenceDirectory = String.valueOf(referenceDirectory) + File.separator;
        }
        this.referenceDirectory = referenceDirectory;
    }

    public void setTestDirectory(String testDirectory) {
        if (!(testDirectory.endsWith("/") | testDirectory.endsWith("\\"))) {
            testDirectory = String.valueOf(testDirectory) + File.separator;
        }
        this.testDirectory = testDirectory;
    }

    public void writeHeader(PrintWriter results) {
        String dateTime = DateFormat.getDateTimeInstance(2, 2).format(new Date());
        results.println("<html><head><title>Test Results</title></head><body>\n");
        results.println("<h2>Compare Results<br>");
        results.println("<font size='1'>created " + dateTime + "</font></h2>");
        results.println("<table cellpadding='10' border='2'><thead><th align='center'>reference file</th><th align='center'>test file</th><th align='center'>identical?</th></thead>");
    }
}

