/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.Page;

public class Marker
extends FObjMixed {
    private String markerClassName;
    private Area registryArea;
    private boolean isFirst;
    private boolean isLast;

    public Marker(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        this.markerClassName = this.properties.get("marker-class-name").getString();
        parent.addMarker(this.markerClassName);
    }

    public String getMarkerClassName() {
        return this.markerClassName;
    }

    public String getName() {
        return "fo:marker";
    }

    public Area getRegistryArea() {
        return this.registryArea;
    }

    public int layout(Area area) throws FOPException {
        this.registryArea = area;
        area.getPage().registerMarker(this);
        return 1;
    }

    public int layoutMarker(Area area) throws FOPException {
        if (this.marker == -1000) {
            this.marker = 0;
        }
        int numChildren = this.children.size();
        int i = this.marker;
        while (i < numChildren) {
            FONode fo = (FONode)this.children.get(i);
            int status = fo.layout(area);
            if (Status.isIncomplete(status)) {
                this.marker = i;
                return status;
            }
            ++i;
        }
        return 1;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public boolean mayPrecedeMarker() {
        return true;
    }

    public void releaseRegistryArea() {
        this.isFirst = this.registryArea.isFirst();
        this.isLast = this.registryArea.isLast();
        this.registryArea = null;
    }

    public void resetMarker() {
        Page page;
        if (this.registryArea != null && (page = this.registryArea.getPage()) != null) {
            page.unregisterMarker(this);
        }
    }

    public void resetMarkerContent() {
        super.resetMarker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new Marker(parent, propertyList, systemId, line, column);
        }
    }
}

