/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionNot;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionAndOr
extends Condition {
    public static final int AND = 0;
    public static final int OR = 1;
    private final int andOrType;
    private Expression left;
    private Expression right;

    public ConditionAndOr(int andOrType, Expression left, Expression right) {
        this.andOrType = andOrType;
        this.left = left;
        this.right = right;
        if (SysProperties.CHECK && (left == null || right == null)) {
            throw Message.getInternalError();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getSQL() {
        void var1_1;
        switch (this.andOrType) {
            case 0: {
                String sql = this.left.getSQL() + " AND " + this.right.getSQL();
                break;
            }
            case 1: {
                String sql = this.left.getSQL() + " OR " + this.right.getSQL();
                break;
            }
            default: {
                throw Message.getInternalError("andOrType=" + this.andOrType);
            }
        }
        return "(" + (String)var1_1 + ")";
    }

    public void createIndexConditions(Session session, TableFilter filter) throws SQLException {
        if (this.andOrType == 0) {
            this.left.createIndexConditions(session, filter);
            this.right.createIndexConditions(session, filter);
        }
    }

    public Expression getNotIfPossible(Session session) {
        Expression r;
        Expression l = this.left.getNotIfPossible(session);
        if (l == null) {
            l = new ConditionNot(this.left);
        }
        if ((r = this.right.getNotIfPossible(session)) == null) {
            r = new ConditionNot(this.right);
        }
        int reversed = this.andOrType == 0 ? 1 : 0;
        return new ConditionAndOr(reversed, l, r);
    }

    public Value getValue(Session session) throws SQLException {
        Value l = this.left.getValue(session);
        switch (this.andOrType) {
            case 0: {
                if (Boolean.FALSE.equals(l.getBoolean())) {
                    return l;
                }
                Value r = this.right.getValue(session);
                if (Boolean.FALSE.equals(r.getBoolean())) {
                    return r;
                }
                if (l == ValueNull.INSTANCE) {
                    return l;
                }
                if (r == ValueNull.INSTANCE) {
                    return r;
                }
                return ValueBoolean.get(true);
            }
            case 1: {
                if (Boolean.TRUE.equals(l.getBoolean())) {
                    return l;
                }
                Value r = this.right.getValue(session);
                if (Boolean.TRUE.equals(r.getBoolean())) {
                    return r;
                }
                if (l == ValueNull.INSTANCE) {
                    return l;
                }
                if (r == ValueNull.INSTANCE) {
                    return r;
                }
                return ValueBoolean.get(false);
            }
        }
        throw Message.getInternalError("type=" + this.andOrType);
    }

    public Expression optimize(Session session) throws SQLException {
        Value r;
        Comparison compRight;
        Comparison compLeft;
        Expression added;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        int lc = this.left.getCost();
        int rc = this.right.getCost();
        if (rc < lc) {
            Expression t = this.left;
            this.left = this.right;
            this.right = t;
        }
        if (SysProperties.OPTIMIZE_NOT && SysProperties.OPTIMIZE_TWO_EQUALS && this.andOrType == 0 && this.left instanceof Comparison && this.right instanceof Comparison && (added = (compLeft = (Comparison)this.left).getAdditional(session, compRight = (Comparison)this.right)) != null) {
            added = ((Expression)added).optimize(session);
            ConditionAndOr a = new ConditionAndOr(0, this, added);
            return a;
        }
        Value l = this.left.isConstant() ? this.left.getValue(session) : null;
        Value value = r = this.right.isConstant() ? this.right.getValue(session) : null;
        if (l == null && r == null) {
            return this;
        }
        if (l != null && r != null) {
            return ValueExpression.get(this.getValue(session));
        }
        switch (this.andOrType) {
            case 0: {
                if (l != null) {
                    if (Boolean.FALSE.equals(l.getBoolean())) {
                        return ValueExpression.get(l);
                    }
                    if (!Boolean.TRUE.equals(l.getBoolean())) break;
                    return this.right;
                }
                if (r == null) break;
                if (Boolean.FALSE.equals(r.getBoolean())) {
                    return ValueExpression.get(r);
                }
                if (!Boolean.TRUE.equals(r.getBoolean())) break;
                return this.left;
            }
            case 1: {
                if (l != null) {
                    if (Boolean.TRUE.equals(l.getBoolean())) {
                        return ValueExpression.get(l);
                    }
                    if (!Boolean.FALSE.equals(l.getBoolean())) break;
                    return this.right;
                }
                if (r == null) break;
                if (Boolean.TRUE.equals(r.getBoolean())) {
                    return ValueExpression.get(r);
                }
                if (!Boolean.FALSE.equals(r.getBoolean())) break;
                return this.left;
            }
            default: {
                throw Message.getInternalError("type=" + this.andOrType);
            }
        }
        return this;
    }

    public void addFilterConditions(TableFilter filter, boolean outerJoin) {
        if (this.andOrType == 0) {
            this.left.addFilterConditions(filter, outerJoin);
            this.right.addFilterConditions(filter, outerJoin);
        } else {
            super.addFilterConditions(filter, outerJoin);
        }
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        this.left.mapColumns(resolver, level);
        this.right.mapColumns(resolver, level);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    public int getCost() {
        return this.left.getCost() + this.right.getCost();
    }
}

