/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.ps.Finalizable;

public class ASCII85OutputStream
extends FilterOutputStream
implements Finalizable {
    private static final int ZERO = 122;
    private static final byte[] ZERO_ARRAY = new byte[]{122};
    private static final int START = 33;
    private static final int EOL = 10;
    private static final byte[] EOD = new byte[]{126, 62};
    private static final long base85_4 = 85L;
    private static final long base85_3 = 7225L;
    private static final long base85_2 = 614125L;
    private static final long base85_1 = 52200625L;
    private static final boolean DEBUG = false;
    private int pos = 0;
    private long buffer = 0L;
    private int posinline = 0;
    private int bw = 0;

    public ASCII85OutputStream(OutputStream out) {
        super(out);
    }

    private void checkedWrite(int b) throws IOException {
        if (this.posinline == 80) {
            this.out.write(10);
            ++this.bw;
            this.posinline = 0;
        }
        this.checkedWrite(b);
        ++this.posinline;
        ++this.bw;
    }

    private void checkedWrite(byte[] buf) throws IOException {
        this.checkedWrite(buf, buf.length, false);
    }

    private void checkedWrite(byte[] buf, int len) throws IOException {
        this.checkedWrite(buf, len, false);
    }

    private void checkedWrite(byte[] buf, int len, boolean nosplit) throws IOException {
        if (this.posinline + len > 80) {
            int firstpart;
            int n = firstpart = nosplit ? 0 : len - (this.posinline + len - 80);
            if (firstpart > 0) {
                this.out.write(buf, 0, firstpart);
            }
            this.out.write(10);
            ++this.bw;
            int rest = len - firstpart;
            if (rest > 0) {
                this.out.write(buf, firstpart, rest);
            }
            this.posinline = rest;
        } else {
            this.out.write(buf, 0, len);
            this.posinline += len;
        }
        this.bw += len;
    }

    private void checkedWrite(byte[] buf, boolean nosplit) throws IOException {
        this.checkedWrite(buf, buf.length, nosplit);
    }

    public void close() throws IOException {
        this.finalizeStream();
        super.close();
    }

    private byte[] convertWord(long word) {
        if ((word &= 0xFFFFFFFFFFFFFFFFL) == 0L) {
            return ZERO_ARRAY;
        }
        if (word < 0L) {
            word = -word;
        }
        byte c1 = (byte)(word / 52200625L & 0xFFL);
        byte c2 = (byte)((word - (long)c1 * 52200625L) / 614125L & 0xFFL);
        byte c3 = (byte)((word - (long)c1 * 52200625L - (long)c2 * 614125L) / 7225L & 0xFFL);
        byte c4 = (byte)((word - (long)c1 * 52200625L - (long)c2 * 614125L - (long)c3 * 7225L) / 85L & 0xFFL);
        byte c5 = (byte)(word - (long)c1 * 52200625L - (long)c2 * 614125L - (long)c3 * 7225L - (long)c4 * 85L & 0xFFL);
        byte[] ret = new byte[]{(byte)(c1 + 33), (byte)(c2 + 33), (byte)(c3 + 33), (byte)(c4 + 33), (byte)(c5 + 33)};
        return ret;
    }

    public void finalizeStream() throws IOException {
        if (this.pos > 0) {
            byte[] conv;
            int rest = this.pos;
            if (this.buffer != 0L) {
                conv = this.convertWord(this.buffer);
            } else {
                conv = new byte[5];
                int j = 0;
                while (j < 5) {
                    conv[j] = 33;
                    ++j;
                }
            }
            this.checkedWrite(conv, rest + 1);
        }
        this.checkedWrite(EOD, true);
        this.flush();
        if (this.out instanceof Finalizable) {
            ((Finalizable)((Object)this.out)).finalizeStream();
        }
    }

    public void write(int b) throws IOException {
        this.buffer = this.pos == 0 ? (this.buffer += (long)(b << 24) & 0xFF000000L) : (this.pos == 1 ? (this.buffer += (long)(b << 16) & 0xFF0000L) : (this.pos == 2 ? (this.buffer += (long)(b << 8) & 0xFF00L) : (this.buffer += (long)b & 0xFFL)));
        ++this.pos;
        if (this.pos > 3) {
            this.checkedWrite(this.convertWord(this.buffer));
            this.buffer = 0L;
            this.pos = 0;
        }
    }
}

