/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class EOFRecord
extends Record {
    public static final short sid = 10;

    public EOFRecord() {
    }

    public EOFRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 10) {
            throw new RecordFormatException("NOT An EOF RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EOF]\n");
        buffer.append("[/EOF]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)10);
        LittleEndian.putShort(data, 2 + offset, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4;
    }

    public short getSid() {
        return 10;
    }

    public Object clone() {
        EOFRecord rec = new EOFRecord();
        return rec;
    }
}

