/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.ViewCursor;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.TableView;
import org.h2.util.IntArray;
import org.h2.util.ObjectArray;
import org.h2.util.SmallLRUCache;
import org.h2.value.Value;

public class ViewIndex
extends BaseIndex {
    private String querySQL;
    private ObjectArray originalParameters;
    private SmallLRUCache costCache = new SmallLRUCache(64);
    private boolean recursive;
    private int[] masks;
    private String planSQL;
    private Query query;
    private Session session;

    public ViewIndex(TableView view, String querySQL, ObjectArray originalParameters, boolean recursive) {
        super(view, 0, null, null, IndexType.createNonUnique(false));
        this.querySQL = querySQL;
        this.originalParameters = originalParameters;
        this.recursive = recursive;
        this.columns = new Column[0];
    }

    public ViewIndex(TableView view, ViewIndex index, Session session, int[] masks) throws SQLException {
        super(view, 0, null, null, IndexType.createNonUnique(false));
        this.querySQL = index.querySQL;
        this.originalParameters = index.originalParameters;
        this.recursive = index.recursive;
        this.masks = masks;
        this.session = session;
        this.columns = new Column[0];
        this.query = this.getQuery(session, masks);
        this.planSQL = this.query.getPlanSQL();
    }

    public Session getSession() {
        return this.session;
    }

    public String getPlanSQL() {
        return this.planSQL;
    }

    public void close(Session session) throws SQLException {
    }

    public void add(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void remove(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public double getCost(Session session, int[] masks) throws SQLException {
        long time;
        IntArray masksArray = new IntArray(masks == null ? new int[]{} : masks);
        CostElement cachedCost = (CostElement)this.costCache.get(masksArray);
        if (cachedCost != null && (time = System.currentTimeMillis()) < cachedCost.evaluatedAt + 10000L) {
            return cachedCost.cost;
        }
        Query query = (Query)session.prepare(this.querySQL, true);
        if (masks == null) {
            this.columns = new Column[0];
        } else {
            IntArray paramIndex = new IntArray();
            for (int i = 0; i < masks.length; ++i) {
                int mask = masks[i];
                if (mask == 0) continue;
                paramIndex.add(i);
            }
            int len = paramIndex.size();
            this.columns = new Column[len];
            for (int i = 0; i < len; ++i) {
                Parameter param;
                Column col;
                int idx = paramIndex.get(i);
                this.columns[i] = col = this.table.getColumn(idx);
                int mask = masks[idx];
                if ((mask & 1) != 0) {
                    param = new Parameter(0);
                    query.addGlobalCondition(param, idx, 0);
                    continue;
                }
                if ((mask & 2) != 0) {
                    param = new Parameter(0);
                    query.addGlobalCondition(param, idx, 1);
                }
                if ((mask & 4) == 0) continue;
                param = new Parameter(0);
                query.addGlobalCondition(param, idx, 3);
            }
            if (this.recursive) {
                return 10.0;
            }
            String sql = query.getPlanSQL();
            query = (Query)session.prepare(sql);
        }
        double cost = query.getCost();
        cachedCost = new CostElement();
        cachedCost.evaluatedAt = System.currentTimeMillis();
        cachedCost.cost = cost;
        this.costCache.put(masksArray, cachedCost);
        return cost;
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) throws SQLException {
        Parameter param;
        ObjectArray paramList = this.query.getParameters();
        int idx = 0;
        for (int i = 0; this.originalParameters != null && i < this.originalParameters.size(); ++i) {
            Parameter orig = (Parameter)this.originalParameters.get(i);
            Value value = orig.getValue(session);
            param = (Parameter)paramList.get(idx++);
            param.setValue(value);
        }
        int len = first != null ? first.getColumnCount() : (last != null ? last.getColumnCount() : 0);
        for (int i = 0; i < len; ++i) {
            Value v;
            if (first != null && (v = first.getValue(i)) != null) {
                param = (Parameter)paramList.get(idx++);
                param.setValue(v);
            }
            if (last == null || this.masks[i] == 1 || (v = last.getValue(i)) == null) continue;
            param = (Parameter)paramList.get(idx++);
            param.setValue(v);
        }
        LocalResult result = this.query.query(0);
        return new ViewCursor(this.table, result);
    }

    private Query getQuery(Session session, int[] masks) throws SQLException {
        Query query = (Query)session.prepare(this.querySQL, true);
        if (masks == null) {
            return query;
        }
        int firstIndexParam = query.getParameters().size();
        IntArray paramIndex = new IntArray();
        for (int i = 0; i < masks.length; ++i) {
            int mask = masks[i];
            if (mask == 0) continue;
            paramIndex.add(i);
            if ((mask & 6) != 6) continue;
            paramIndex.add(i);
        }
        int len = paramIndex.size();
        this.columns = new Column[len];
        int i = 0;
        while (i < len) {
            Parameter param;
            Column col;
            int idx = paramIndex.get(i);
            this.columns[i] = col = this.table.getColumn(idx);
            int mask = masks[idx];
            if ((mask & 1) == 1) {
                param = new Parameter(firstIndexParam + i);
                query.addGlobalCondition(param, idx, 0);
                ++i;
                continue;
            }
            if ((mask & 2) == 2) {
                param = new Parameter(firstIndexParam + i);
                query.addGlobalCondition(param, idx, 1);
                ++i;
            }
            if ((mask & 4) != 4) continue;
            param = new Parameter(firstIndexParam + i);
            query.addGlobalCondition(param, idx, 3);
            ++i;
        }
        String sql = query.getPlanSQL();
        query = (Query)session.prepare(sql, true);
        return query;
    }

    public void remove(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast(boolean first) {
        return false;
    }

    public SearchRow findFirstOrLast(Session session, boolean first) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void setRecursive(boolean value) {
        this.recursive = value;
    }

    private static class CostElement {
        long evaluatedAt;
        double cost;

        private CostElement() {
        }
    }
}

