/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class ContinueRecord
extends Record {
    public static final short sid = 60;
    private byte[] field_1_data;

    public ContinueRecord() {
    }

    public ContinueRecord(RecordInputStream in) {
        super(in);
    }

    public byte[] serialize() {
        byte[] retval = new byte[this.field_1_data.length + 4];
        this.serialize(0, retval);
        return retval;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, offset, (short)60);
        LittleEndian.putShort(data, offset + 2, (short)this.field_1_data.length);
        System.arraycopy(this.field_1_data, 0, data, offset + 4, this.field_1_data.length);
        return this.field_1_data.length + 4;
    }

    public void setData(byte[] data) {
        this.field_1_data = data;
    }

    public byte[] getData() {
        return this.field_1_data;
    }

    protected void validateSid(short id) {
        if (id != 60) {
            throw new RecordFormatException("Not a Continue Record");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CONTINUE RECORD]\n");
        buffer.append("    .id        = ").append(Integer.toHexString(60)).append("\n");
        buffer.append("[/CONTINUE RECORD]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 60;
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_data = in.readRemainder();
    }

    public Object clone() {
        ContinueRecord clone = new ContinueRecord();
        clone.setData(this.field_1_data);
        return clone;
    }
}

