/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.batik.ext.awt.image.CompositeRule;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.CompositeRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.CompositeRed;
import org.apache.batik.ext.awt.image.rendered.FloodRed;

public class CompositeRable8Bit
extends AbstractColorInterpolationRable
implements CompositeRable,
PaintRable {
    protected CompositeRule rule;

    public CompositeRable8Bit(List list, CompositeRule compositeRule, boolean bl) {
        super(list);
        this.setColorSpaceLinear(bl);
        this.rule = compositeRule;
    }

    public void setSources(List list) {
        this.init(list, null);
    }

    public void setCompositeRule(CompositeRule compositeRule) {
        this.touch();
        this.rule = compositeRule;
    }

    public CompositeRule getCompositeRule() {
        return this.rule;
    }

    public boolean paintRable(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        if (!SVGComposite.OVER.equals(composite)) {
            return false;
        }
        if (this.getCompositeRule() != CompositeRule.OVER) {
            return false;
        }
        ColorSpace colorSpace = this.getOperationColorSpace();
        ColorSpace colorSpace2 = GraphicsUtil.getDestinationColorSpace(graphics2D);
        if (colorSpace2 == null || colorSpace2 != colorSpace) {
            return false;
        }
        Iterator iterator = this.getSources().iterator();
        while (iterator.hasNext()) {
            GraphicsUtil.drawImage(graphics2D, (Filter)iterator.next());
        }
        return true;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Object object;
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        if (this.srcs.size() == 0) {
            return null;
        }
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            rectangle2D2 = this.getBounds2D();
        } else {
            rectangle2D2 = shape.getBounds2D();
            rectangle2D = this.getBounds2D();
            if (!rectangle2D.intersects(rectangle2D2)) {
                return null;
            }
            Rectangle2D.intersect(rectangle2D2, rectangle2D, rectangle2D2);
        }
        rectangle2D = affineTransform.createTransformedShape(rectangle2D2).getBounds();
        renderContext = new RenderContext(affineTransform, rectangle2D2, renderingHints);
        Vector<CachableRed> vector = new Vector<CachableRed>();
        Iterator iterator = this.getSources().iterator();
        block5: while (iterator.hasNext()) {
            object = (Filter)iterator.next();
            RenderedImage renderedImage = object.createRendering(renderContext);
            if (renderedImage != null) {
                CachableRed cachableRed = this.convertSourceCS(renderedImage);
                vector.add(cachableRed);
                continue;
            }
            switch (this.rule.getRule()) {
                case 2: {
                    return null;
                }
                case 3: {
                    vector.clear();
                    continue block5;
                }
                case 6: {
                    vector.add(new FloodRed((Rectangle)rectangle2D));
                    continue block5;
                }
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        object = new CompositeRed(vector, this.rule);
        return object;
    }
}

