/*
 * Copyright 2004-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.framework.container.factory;

import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.MetaDefAware;
import org.seasar.framework.container.impl.MetaDefImpl;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.xml.TagHandler;
import org.seasar.framework.xml.TagHandlerContext;
import org.xml.sax.Attributes;

/**
 * @author higa
 * 
 */
public class MetaTagHandler extends TagHandler {

    private static final long serialVersionUID = -3372861766134433725L;

    /**
     * @see org.seasar.framework.xml.sax.handler.TagHandler#start(org.seasar.framework.xml.sax.handler.TagHandlerContext,
     *      org.xml.sax.Attributes)
     */
    public void start(TagHandlerContext context, Attributes attributes) {
        String name = attributes.getValue("name");
        context.push(createMetaDef(name));
    }

    /**
     * @see org.seasar.framework.xml.sax.handler.TagHandler#end(org.seasar.framework.xml.sax.handler.TagHandlerContext,
     *      java.lang.String)
     */
    public void end(TagHandlerContext context, String body) {
        MetaDef metaDef = (MetaDef) context.pop();
        if (!StringUtil.isEmpty(body)) {
            metaDef.setExpression(body);
        }
        MetaDefAware metaDefAware = (MetaDefAware) context.peek();
        metaDefAware.addMetaDef(metaDef);
    }

    protected MetaDefImpl createMetaDef(String name) {
        return new MetaDefImpl(name);
    }
}
