/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.creator;

import java.lang.reflect.Modifier;
import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.ComponentCustomizer;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AnnotationHandlerFactory;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.exception.EmptyRuntimeException;

public class ComponentCreatorImpl
implements ComponentCreator {
    private NamingConvention namingConvention;
    public static final String instanceDef_BINDING = "bindingType=may";
    private InstanceDef instanceDef;
    public static final String autoBindingDef_BINDING = "bindingType=may";
    private AutoBindingDef autoBindingDef;
    public static final String externalBinding_BINDING = "bindingType=may";
    private boolean externalBinding = false;
    public static final String enableInterface_BINDING = "bindingType=may";
    private boolean enableInterface = false;
    public static final String enableAbstract_BINDING = "bindingType=may";
    private boolean enableAbstract = false;
    private String nameSuffix;
    private ComponentCustomizer customizer;

    public ComponentCreatorImpl(NamingConvention namingConvention) {
        if (namingConvention == null) {
            throw new EmptyRuntimeException("namingConvetion");
        }
        this.namingConvention = namingConvention;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public InstanceDef getInstanceDef() {
        return this.instanceDef;
    }

    public void setInstanceDef(InstanceDef instanceDef) {
        this.instanceDef = instanceDef;
    }

    public AutoBindingDef getAutoBindingDef() {
        return this.autoBindingDef;
    }

    public void setAutoBindingDef(AutoBindingDef autoBindingDef) {
        this.autoBindingDef = autoBindingDef;
    }

    public boolean isExternalBinding() {
        return this.externalBinding;
    }

    public void setExternalBinding(boolean externalBinding) {
        this.externalBinding = externalBinding;
    }

    public boolean isEnableInterface() {
        return this.enableInterface;
    }

    public void setEnableInterface(boolean enableInterface) {
        this.enableInterface = enableInterface;
    }

    public boolean isEnableAbstract() {
        return this.enableAbstract;
    }

    public void setEnableAbstract(boolean enableAbstract) {
        this.enableAbstract = enableAbstract;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    protected ComponentCustomizer getCustomizer() {
        return this.customizer;
    }

    protected void setCustomizer(ComponentCustomizer customizer) {
        this.customizer = customizer;
    }

    public ComponentDef createComponentDef(Class componentClass) {
        if (!this.namingConvention.isTargetClassName(componentClass.getName(), this.nameSuffix)) {
            return null;
        }
        Class targetClass = this.namingConvention.toCompleteClass(componentClass);
        if (targetClass.isInterface() ? !this.isEnableInterface() : Modifier.isAbstract(targetClass.getModifiers()) && !this.isEnableAbstract()) {
            return null;
        }
        AnnotationHandler handler = AnnotationHandlerFactory.getAnnotationHandler();
        ComponentDef cd = handler.createComponentDef(targetClass, this.instanceDef, this.autoBindingDef, this.externalBinding);
        if (cd.getComponentName() == null) {
            cd.setComponentName(this.namingConvention.fromClassNameToComponentName(targetClass.getName()));
        }
        handler.appendDI(cd);
        this.customize(cd);
        handler.appendInitMethod(cd);
        handler.appendDestroyMethod(cd);
        handler.appendAspect(cd);
        handler.appendInterType(cd);
        return cd;
    }

    public ComponentDef createComponentDef(String componentName) {
        if (!this.isTargetComponentName(componentName)) {
            return null;
        }
        Class componentClass = this.namingConvention.fromComponentNameToClass(componentName);
        if (componentClass == null) {
            return null;
        }
        return this.createComponentDef(componentClass);
    }

    public boolean isTargetComponentName(String componentName) {
        return componentName.endsWith(this.nameSuffix);
    }

    protected void customize(ComponentDef componentDef) {
        if (this.customizer != null) {
            this.customizer.customize(componentDef);
        }
    }
}

