/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.util;

import java.math.BigInteger;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpSession;
import org.seasar.cubby.internal.util.LruHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenHelper {
    private static final int TOKEN_HISTORY_SIZE = 16;
    public static final String DEFAULT_TOKEN_NAME = "cubby.token";
    private static final Random RANDOM = new Random();

    public static String generateGUID() {
        return new BigInteger(165, RANDOM).toString(36).toUpperCase();
    }

    public static Map<String, String> getTokenMap(HttpSession session) {
        LruHashMap tokenMap = (LruHashMap)session.getAttribute("org.seasar.cubby.token");
        if (tokenMap == null) {
            tokenMap = new LruHashMap(16);
            session.setAttribute("org.seasar.cubby.token", tokenMap);
        }
        return tokenMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setToken(HttpSession session, String token) {
        Map<String, String> tokenMap;
        Map<String, String> map = tokenMap = TokenHelper.getTokenMap(session);
        synchronized (map) {
            tokenMap.put(token, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateToken(HttpSession session, String token) {
        Map<String, String> tokenMap;
        Map<String, String> map = tokenMap = TokenHelper.getTokenMap(session);
        synchronized (map) {
            boolean success = tokenMap.containsKey(token);
            tokenMap.remove(token);
            return success;
        }
    }
}

