/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTag;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.controller.FormWrapper;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.tags.CubbyFunctions;
import org.seasar.cubby.tags.DynamicAttributesSimpleTagSupport;
import org.seasar.cubby.tags.TagUtils;

public class InputTag
extends DynamicAttributesSimpleTagSupport {
    private static final Set<String> MULTIPLE_VALUE_TYPES;
    private String type;
    private String name;
    private Object value;
    private String checkedValue;
    private Integer index;

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCheckedValue(String checkedValue) {
        this.checkedValue = checkedValue;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void doTag() throws JspException, IOException {
        JspContext context = this.getJspContext();
        JspWriter out = context.getOut();
        ActionErrors errors = TagUtils.errors(context);
        Map<String, Object> dyn = this.getDynamicAttributes();
        FormWrapper formWrapper = TagUtils.getFormWrapper((SimpleTag)this);
        if (this.index == null) {
            if (!errors.getFields().get(this.name).isEmpty()) {
                TagUtils.addCSSClassName(dyn, "fieldError");
            }
        } else if (!errors.getIndexedFields().get(this.name).get(this.index).isEmpty()) {
            TagUtils.addCSSClassName(dyn, "fieldError");
        }
        if (MULTIPLE_VALUE_TYPES.contains(this.type)) {
            if (this.value == null) {
                throw new JspTagException(LogMessages.format("ECUB1003", MULTIPLE_VALUE_TYPES, "value"));
            }
            Object[] values = TagUtils.multipleFormValues(context, formWrapper, this.name, this.checkedValue);
            out.write("<input type=\"");
            out.write(this.type);
            out.write("\" name=\"");
            out.write(this.name);
            out.write("\" value=\"");
            out.write(CubbyFunctions.out(this.value));
            out.write("\" ");
            out.write(TagUtils.toAttr(dyn));
            out.write(" ");
            out.write(InputTag.checked(TagUtils.toString(this.value), values));
            out.write("/>");
        } else {
            Object value = TagUtils.formValue(context, formWrapper, this.name, this.index, this.value);
            out.write("<input type=\"");
            out.write(this.type);
            out.write("\" name=\"");
            out.write(this.name);
            out.write("\" value=\"");
            out.write(CubbyFunctions.out(TagUtils.toString(value)));
            out.write("\" ");
            out.write(TagUtils.toAttr(dyn));
            out.write("/>");
        }
    }

    private static String checked(String value, Object values) {
        if (value == null || values == null) {
            return "";
        }
        if (TagUtils.contains(values, value)) {
            return "checked=\"checked\"";
        }
        return "";
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("checkbox");
        set.add("radio");
        MULTIPLE_VALUE_TYPES = Collections.unmodifiableSet(set);
    }
}

