/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.util;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleMap
extends AbstractMap<String, Object> {
    private final ResourceBundle resourceBundle;
    private Set<Map.Entry<String, Object>> entrySet;

    public ResourceBundleMap(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    @Override
    public Object get(Object key) {
        return this.resourceBundle.getString((String)key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            LinkedHashSet<UnmodifiableEntry<String, Object>> entrySet = new LinkedHashSet<UnmodifiableEntry<String, Object>>();
            Enumeration<String> keys = this.resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object value = this.resourceBundle.getObject(key);
                UnmodifiableEntry<String, Object> entry = new UnmodifiableEntry<String, Object>(key, value);
                entrySet.add(entry);
            }
            this.entrySet = Collections.unmodifiableSet(entrySet);
        }
        return this.entrySet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public UnmodifiableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

