/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import java.io.IOException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SyslogWriter
extends Writer {
    private static final int MAX_LEN = 1024;
    private InetAddress address;
    private DatagramSocket ds;
    private StringBuffer buf = new StringBuffer();
    private final int port;

    public SyslogWriter(String syslogHost, int port) throws UnknownHostException, SocketException {
        this.address = InetAddress.getByName(syslogHost);
        this.port = port;
        this.ds = new DatagramSocket();
    }

    public void write(char[] charArray, int offset, int len) throws IOException {
        this.buf.append(charArray, offset, len);
    }

    public void write(String str) throws IOException {
        this.buf.append(str);
    }

    public void flush() throws IOException {
        byte[] bytes = this.buf.toString().getBytes();
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.address, this.port);
        if (this.ds != null) {
            this.ds.send(packet);
        }
        if (this.buf.length() > 1024) {
            this.buf = new StringBuffer();
        } else {
            this.buf.setLength(0);
        }
    }

    public void close() {
        this.address = null;
        this.ds = null;
    }

    public int getPort() {
        return this.port;
    }
}

