/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.contrib.poibrowser;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.apache.poi.contrib.poibrowser.DocumentDescriptorRenderer;
import org.apache.poi.contrib.poibrowser.ExtendableTreeCellRenderer;
import org.apache.poi.contrib.poibrowser.PropertySetDescriptorRenderer;
import org.apache.poi.contrib.poibrowser.TreeReaderListener;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;

public class POIBrowser
extends JFrame {
    protected MutableTreeNode rootNode;
    static /* synthetic */ Class class$org$apache$poi$contrib$poibrowser$DocumentDescriptor;
    static /* synthetic */ Class class$org$apache$poi$contrib$poibrowser$PropertySetDescriptor;

    public static void main(String[] args) {
        new POIBrowser().run(args);
    }

    protected void run(String[] args) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.rootNode = new DefaultMutableTreeNode("POI Filesystems");
        DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
        JTree treeUI = new JTree(treeModel);
        this.getContentPane().add(new JScrollPane(treeUI));
        int displayedFiles = 0;
        for (int i = 0; i < args.length; ++i) {
            String filename = args[i];
            try {
                POIFSReader r = new POIFSReader();
                r.registerListener(new TreeReaderListener(filename, this.rootNode));
                r.read(new FileInputStream(filename));
                ++displayedFiles;
                continue;
            }
            catch (IOException ex) {
                System.err.println(filename + ": " + ex);
                continue;
            }
            catch (Throwable t) {
                System.err.println("Unexpected exception while reading \"" + filename + "\":");
                t.printStackTrace(System.err);
            }
        }
        if (displayedFiles == 0) {
            System.out.println("No POI filesystem(s) to display.");
            System.exit(0);
        }
        treeUI.setRootVisible(true);
        treeUI.setShowsRootHandles(true);
        ExtendableTreeCellRenderer etcr = new ExtendableTreeCellRenderer();
        etcr.register(class$org$apache$poi$contrib$poibrowser$DocumentDescriptor == null ? (class$org$apache$poi$contrib$poibrowser$DocumentDescriptor = POIBrowser.class$("org.apache.poi.contrib.poibrowser.DocumentDescriptor")) : class$org$apache$poi$contrib$poibrowser$DocumentDescriptor, new DocumentDescriptorRenderer());
        etcr.register(class$org$apache$poi$contrib$poibrowser$PropertySetDescriptor == null ? (class$org$apache$poi$contrib$poibrowser$PropertySetDescriptor = POIBrowser.class$("org.apache.poi.contrib.poibrowser.PropertySetDescriptor")) : class$org$apache$poi$contrib$poibrowser$PropertySetDescriptor, new PropertySetDescriptorRenderer());
        treeUI.setCellRenderer(etcr);
        this.setSize(600, 450);
        this.setTitle("POI Browser 0.09");
        this.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

