/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Stage;
import com.google.inject.servlet.DefaultFilterPipeline;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.ManagedFilterPipeline;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GuiceFilter
implements Filter {
    static final ThreadLocal<Context> localContext = new ThreadLocal();
    static volatile FilterPipeline pipeline = new DefaultFilterPipeline();
    static volatile WeakReference<ServletContext> servletContext = new WeakReference<Object>(null);
    private static final String MULTIPLE_INJECTORS_ERROR = "Multiple injectors detected. Please install only one ServletModule in your web application. While you may have more than one injector, you should only configure guice-servlet in one of them. (Hint: look for legacy ServetModules or multiple calls to Servlets.configure()).";

    @Inject
    static void setPipeline(FilterPipeline pipeline, Stage stage) {
        if (GuiceFilter.pipeline instanceof ManagedFilterPipeline) {
            if (Stage.PRODUCTION.equals((Object)stage)) {
                throw new RuntimeException(MULTIPLE_INJECTORS_ERROR);
            }
            Logger.getLogger(GuiceFilter.class.getName()).warning(MULTIPLE_INJECTORS_ERROR);
        }
        GuiceFilter.pipeline = pipeline;
    }

    static void reset() {
        pipeline = new DefaultFilterPipeline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Context previous = localContext.get();
        FilterPipeline filterPipeline = pipeline;
        try {
            localContext.set(new Context((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse));
            filterPipeline.dispatch(servletRequest, servletResponse, filterChain);
        }
        finally {
            localContext.set(previous);
        }
    }

    static HttpServletRequest getRequest() {
        return GuiceFilter.getContext().getRequest();
    }

    static HttpServletResponse getResponse() {
        return GuiceFilter.getContext().getResponse();
    }

    static ServletContext getServletContext() {
        return (ServletContext)servletContext.get();
    }

    static Context getContext() {
        Context context = localContext.get();
        if (context == null) {
            throw new OutOfScopeException("Cannot access scoped object. Either we are not currently inside an HTTP Servlet request, or you may have forgotten to apply " + GuiceFilter.class.getName() + " as a servlet filter for this request.");
        }
        return context;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        GuiceFilter.servletContext = new WeakReference<ServletContext>(servletContext);
        pipeline.initPipeline(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            pipeline.destroyPipeline();
        }
        finally {
            GuiceFilter.reset();
            servletContext.clear();
        }
    }

    static class Context {
        final HttpServletRequest request;
        final HttpServletResponse response;

        Context(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        HttpServletRequest getRequest() {
            return this.request;
        }

        HttpServletResponse getResponse() {
            return this.response;
        }
    }
}

