/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.apache.taglibs.standard.lang.jstl.ArithmeticOperator;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.EqualityOperator;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.PrimitiveObjects;
import org.apache.taglibs.standard.lang.jstl.RelationalOperator;

public class Coercions {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static Object coerce(Object object, Class clazz, Logger logger) throws ELException {
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Coercions.class$("java.lang.String")) : class$java$lang$String)) {
            return Coercions.coerceToString(object, logger);
        }
        if (Coercions.isPrimitiveNumberClass(clazz)) {
            return Coercions.coerceToPrimitiveNumber(object, clazz, logger);
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Coercions.class$("java.lang.Character")) : class$java$lang$Character) || clazz == Character.TYPE) {
            return Coercions.coerceToCharacter(object, logger);
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Coercions.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz == Boolean.TYPE) {
            return Coercions.coerceToBoolean(object, logger);
        }
        return Coercions.coerceToObject(object, clazz, logger);
    }

    static boolean isPrimitiveNumberClass(Class clazz) {
        return clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE;
    }

    public static String coerceToString(Object object, Logger logger) throws ELException {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return object.toString();
        }
        catch (Exception exception) {
            if (logger.isLoggingError()) {
                logger.logError(Constants.TOSTRING_EXCEPTION, exception, (Object)object.getClass().getName());
            }
            return "";
        }
    }

    public static Number coerceToPrimitiveNumber(Object object, Class clazz, Logger logger) throws ELException {
        if (object == null || "".equals(object)) {
            return Coercions.coerceToPrimitiveNumber(0L, clazz);
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            return Coercions.coerceToPrimitiveNumber((short)c, clazz);
        }
        if (object instanceof Boolean) {
            if (logger.isLoggingError()) {
                logger.logError(Constants.BOOLEAN_TO_NUMBER, object, (Object)clazz.getName());
            }
            return Coercions.coerceToPrimitiveNumber(0L, clazz);
        }
        if (object.getClass() == clazz) {
            return (Number)object;
        }
        if (object instanceof Number) {
            return Coercions.coerceToPrimitiveNumber((Number)object, clazz);
        }
        if (object instanceof String) {
            try {
                return Coercions.coerceToPrimitiveNumber((String)object, clazz);
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.STRING_TO_NUMBER_EXCEPTION, (String)object, (Object)clazz.getName());
                }
                return Coercions.coerceToPrimitiveNumber(0L, clazz);
            }
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.COERCE_TO_NUMBER, object.getClass().getName(), (Object)clazz.getName());
        }
        return Coercions.coerceToPrimitiveNumber(0L, clazz);
    }

    public static Integer coerceToInteger(Object object, Logger logger) throws ELException {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return PrimitiveObjects.getInteger(((Character)object).charValue());
        }
        if (object instanceof Boolean) {
            if (logger.isLoggingWarning()) {
                logger.logWarning(Constants.BOOLEAN_TO_NUMBER, object, (Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
            }
            return PrimitiveObjects.getInteger((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return PrimitiveObjects.getInteger(((Number)object).intValue());
        }
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (Exception exception) {
                if (logger.isLoggingWarning()) {
                    logger.logWarning(Constants.STRING_TO_NUMBER_EXCEPTION, (String)object, (Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
                }
                return null;
            }
        }
        if (logger.isLoggingWarning()) {
            logger.logWarning(Constants.COERCE_TO_NUMBER, object.getClass().getName(), (Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
        }
        return null;
    }

    static Number coerceToPrimitiveNumber(long l, Class clazz) throws ELException {
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)l);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE) {
            return PrimitiveObjects.getShort((short)l);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)l);
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE) {
            return PrimitiveObjects.getLong(l);
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE) {
            return PrimitiveObjects.getFloat(l);
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE) {
            return PrimitiveObjects.getDouble(l);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(double d, Class clazz) throws ELException {
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)d);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE) {
            return PrimitiveObjects.getShort((short)d);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)d);
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE) {
            return PrimitiveObjects.getLong((long)d);
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE) {
            return PrimitiveObjects.getFloat((float)d);
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE) {
            return PrimitiveObjects.getDouble(d);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(Number number, Class clazz) throws ELException {
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE) {
            return PrimitiveObjects.getByte(number.byteValue());
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE) {
            return PrimitiveObjects.getShort(number.shortValue());
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE) {
            return PrimitiveObjects.getInteger(number.intValue());
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE) {
            return PrimitiveObjects.getLong(number.longValue());
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE) {
            return PrimitiveObjects.getFloat(number.floatValue());
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE) {
            return PrimitiveObjects.getDouble(number.doubleValue());
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(String string, Class clazz) throws ELException {
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE) {
            return Byte.valueOf(string);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE) {
            return Short.valueOf(string);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE) {
            return Integer.valueOf(string);
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE) {
            return Long.valueOf(string);
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE) {
            return Float.valueOf(string);
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE) {
            return Double.valueOf(string);
        }
        return PrimitiveObjects.getInteger(0);
    }

    public static Character coerceToCharacter(Object object, Logger logger) throws ELException {
        if (object == null || "".equals(object)) {
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof Boolean) {
            if (logger.isLoggingError()) {
                logger.logError(Constants.BOOLEAN_TO_CHARACTER, object);
            }
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (object instanceof Number) {
            return PrimitiveObjects.getCharacter((char)((Number)object).shortValue());
        }
        if (object instanceof String) {
            String string = (String)object;
            return PrimitiveObjects.getCharacter(string.charAt(0));
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.COERCE_TO_CHARACTER, object.getClass().getName());
        }
        return PrimitiveObjects.getCharacter('\u0000');
    }

    public static Boolean coerceToBoolean(Object object, Logger logger) throws ELException {
        if (object == null || "".equals(object)) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Boolean.valueOf(string);
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.STRING_TO_BOOLEAN, exception, (Object)((String)object));
                }
                return Boolean.FALSE;
            }
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.COERCE_TO_BOOLEAN, object.getClass().getName());
        }
        return Boolean.TRUE;
    }

    public static Object coerceToObject(Object object, Class clazz, Logger logger) throws ELException {
        if (object == null) {
            return null;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        if (object instanceof String) {
            String string = (String)object;
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
            if (propertyEditor == null) {
                if ("".equals(string)) {
                    return null;
                }
                if (logger.isLoggingError()) {
                    logger.logError(Constants.NO_PROPERTY_EDITOR, string, (Object)clazz.getName());
                }
                return null;
            }
            try {
                propertyEditor.setAsText(string);
                return propertyEditor.getValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("".equals(string)) {
                    return null;
                }
                if (logger.isLoggingError()) {
                    logger.logError(Constants.PROPERTY_EDITOR_ERROR, illegalArgumentException, object, (Object)clazz.getName());
                }
                return null;
            }
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.COERCE_TO_OBJECT, object.getClass().getName(), (Object)clazz.getName());
        }
        return null;
    }

    public static Object applyArithmeticOperator(Object object, Object object2, ArithmeticOperator arithmeticOperator, Logger logger) throws ELException {
        if (object == null && object2 == null) {
            if (logger.isLoggingWarning()) {
                logger.logWarning(Constants.ARITH_OP_NULL, arithmeticOperator.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointType(object2) || Coercions.isFloatingPointString(object) || Coercions.isFloatingPointString(object2)) {
            double d = Coercions.coerceToPrimitiveNumber(object, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, logger).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, logger).doubleValue();
            return PrimitiveObjects.getDouble(arithmeticOperator.apply(d, d2, logger));
        }
        long l = Coercions.coerceToPrimitiveNumber(object, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, logger).longValue();
        long l2 = Coercions.coerceToPrimitiveNumber(object2, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, logger).longValue();
        return PrimitiveObjects.getLong(arithmeticOperator.apply(l, l2, logger));
    }

    public static Object applyRelationalOperator(Object object, Object object2, RelationalOperator relationalOperator, Logger logger) throws ELException {
        if (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointType(object2)) {
            double d = Coercions.coerceToPrimitiveNumber(object, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, logger).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, logger).doubleValue();
            return PrimitiveObjects.getBoolean(relationalOperator.apply(d, d2, logger));
        }
        if (Coercions.isIntegerType(object) || Coercions.isIntegerType(object2)) {
            long l = Coercions.coerceToPrimitiveNumber(object, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, logger).longValue();
            long l2 = Coercions.coerceToPrimitiveNumber(object2, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, logger).longValue();
            return PrimitiveObjects.getBoolean(relationalOperator.apply(l, l2, logger));
        }
        if (object instanceof String || object2 instanceof String) {
            String string = Coercions.coerceToString(object, logger);
            String string2 = Coercions.coerceToString(object2, logger);
            return PrimitiveObjects.getBoolean(relationalOperator.apply(string, string2, logger));
        }
        if (object instanceof Comparable) {
            try {
                int n = ((Comparable)object).compareTo(object2);
                return PrimitiveObjects.getBoolean(relationalOperator.apply(n, -n, logger));
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.COMPARABLE_ERROR, exception, (Object)object.getClass().getName(), (Object)(object2 == null ? "null" : object2.getClass().getName()), (Object)relationalOperator.getOperatorSymbol());
                }
                return Boolean.FALSE;
            }
        }
        if (object2 instanceof Comparable) {
            try {
                int n = ((Comparable)object2).compareTo(object);
                return PrimitiveObjects.getBoolean(relationalOperator.apply(-n, n, logger));
            }
            catch (Exception exception) {
                if (logger.isLoggingError()) {
                    logger.logError(Constants.COMPARABLE_ERROR, exception, (Object)object2.getClass().getName(), (Object)(object == null ? "null" : object.getClass().getName()), (Object)relationalOperator.getOperatorSymbol());
                }
                return Boolean.FALSE;
            }
        }
        if (logger.isLoggingError()) {
            logger.logError(Constants.ARITH_OP_BAD_TYPE, relationalOperator.getOperatorSymbol(), (Object)object.getClass().getName(), (Object)object2.getClass().getName());
        }
        return Boolean.FALSE;
    }

    public static Object applyEqualityOperator(Object object, Object object2, EqualityOperator equalityOperator, Logger logger) throws ELException {
        if (object == object2) {
            return PrimitiveObjects.getBoolean(equalityOperator.apply(true, logger));
        }
        if (object == null || object2 == null) {
            return PrimitiveObjects.getBoolean(equalityOperator.apply(false, logger));
        }
        if (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointType(object2)) {
            double d = Coercions.coerceToPrimitiveNumber(object, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, logger).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, logger).doubleValue();
            return PrimitiveObjects.getBoolean(equalityOperator.apply(d == d2, logger));
        }
        if (Coercions.isIntegerType(object) || Coercions.isIntegerType(object2)) {
            long l = Coercions.coerceToPrimitiveNumber(object, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, logger).longValue();
            long l2 = Coercions.coerceToPrimitiveNumber(object2, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, logger).longValue();
            return PrimitiveObjects.getBoolean(equalityOperator.apply(l == l2, logger));
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = Coercions.coerceToBoolean(object, logger);
            return PrimitiveObjects.getBoolean(equalityOperator.apply(bl2 == (bl = Coercions.coerceToBoolean(object2, logger).booleanValue()), logger));
        }
        if (object instanceof String || object2 instanceof String) {
            String string = Coercions.coerceToString(object, logger);
            String string2 = Coercions.coerceToString(object2, logger);
            return PrimitiveObjects.getBoolean(equalityOperator.apply(string.equals(string2), logger));
        }
        try {
            return PrimitiveObjects.getBoolean(equalityOperator.apply(object.equals(object2), logger));
        }
        catch (Exception exception) {
            if (logger.isLoggingError()) {
                logger.logError(Constants.ERROR_IN_EQUALS, exception, (Object)object.getClass().getName(), (Object)object2.getClass().getName(), (Object)equalityOperator.getOperatorSymbol());
            }
            return Boolean.FALSE;
        }
    }

    public static boolean isFloatingPointType(Object object) {
        return object != null && Coercions.isFloatingPointType(object.getClass());
    }

    public static boolean isFloatingPointType(Class clazz) {
        return clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE;
    }

    public static boolean isFloatingPointString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c != '.' && c != 'e' && c != 'E') continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isIntegerType(Object object) {
        return object != null && Coercions.isIntegerType(object.getClass());
    }

    public static boolean isIntegerType(Class clazz) {
        return clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Coercions.class$("java.lang.Character")) : class$java$lang$Character) || clazz == Character.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

