/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;
import org.apache.taglibs.standard.tag.common.fmt.TimeZoneSupport;

public abstract class FormatDateSupport
extends TagSupport {
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final String DATETIME = "both";
    protected Date value;
    protected String type;
    protected String pattern;
    protected Object timeZone;
    protected String dateStyle;
    protected String timeStyle;
    private String var;
    private int scope;

    public FormatDateSupport() {
        this.init();
    }

    private void init() {
        this.timeStyle = null;
        this.dateStyle = null;
        this.type = null;
        this.var = null;
        this.pattern = null;
        this.value = null;
        this.timeZone = null;
        this.scope = 1;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        String string = null;
        if (this.value == null) {
            if (this.var == null) return 6;
            this.pageContext.removeAttribute(this.var, this.scope);
            return 6;
        }
        Locale locale = SetLocaleSupport.getFormattingLocale(this.pageContext, (Tag)this, true, DateFormat.getAvailableLocales());
        if (locale != null) {
            DateFormat dateFormat = this.createFormatter(locale);
            if (this.pattern != null) {
                try {
                    ((SimpleDateFormat)dateFormat).applyPattern(this.pattern);
                }
                catch (ClassCastException classCastException) {
                    dateFormat = new SimpleDateFormat(this.pattern, locale);
                }
            }
            TimeZone timeZone = null;
            if (this.timeZone instanceof String && ((String)this.timeZone).equals("")) {
                this.timeZone = null;
            }
            if (this.timeZone != null) {
                if (this.timeZone instanceof String) {
                    timeZone = TimeZone.getTimeZone((String)this.timeZone);
                } else {
                    if (!(this.timeZone instanceof TimeZone)) throw new JspTagException(Resources.getMessage("FORMAT_DATE_BAD_TIMEZONE"));
                    timeZone = (TimeZone)this.timeZone;
                }
            } else {
                timeZone = TimeZoneSupport.getTimeZone(this.pageContext, (Tag)this);
            }
            if (timeZone != null) {
                dateFormat.setTimeZone(timeZone);
            }
            string = dateFormat.format(this.value);
        } else {
            string = this.value.toString();
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)string, this.scope);
            return 6;
        }
        try {
            this.pageContext.getOut().print(string);
            return 6;
        }
        catch (IOException iOException) {
            throw new JspTagException(iOException.toString(), (Throwable)iOException);
        }
    }

    public void release() {
        this.init();
    }

    private DateFormat createFormatter(Locale locale) throws JspException {
        DateFormat dateFormat = null;
        if (this.type == null || DATE.equalsIgnoreCase(this.type)) {
            dateFormat = DateFormat.getDateInstance(Util.getStyle(this.dateStyle, "FORMAT_DATE_INVALID_DATE_STYLE"), locale);
        } else if (TIME.equalsIgnoreCase(this.type)) {
            dateFormat = DateFormat.getTimeInstance(Util.getStyle(this.timeStyle, "FORMAT_DATE_INVALID_TIME_STYLE"), locale);
        } else if (DATETIME.equalsIgnoreCase(this.type)) {
            dateFormat = DateFormat.getDateTimeInstance(Util.getStyle(this.dateStyle, "FORMAT_DATE_INVALID_DATE_STYLE"), Util.getStyle(this.timeStyle, "FORMAT_DATE_INVALID_TIME_STYLE"), locale);
        } else {
            throw new JspException(Resources.getMessage("FORMAT_DATE_INVALID_TYPE", this.type));
        }
        return dateFormat;
    }
}

