/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.spi.beans.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.cubby.internal.util.ReflectionUtils;
import org.seasar.cubby.spi.BeanDescProvider;
import org.seasar.cubby.spi.beans.Attribute;
import org.seasar.cubby.spi.beans.AttributeNotFoundException;
import org.seasar.cubby.spi.beans.BeanDesc;
import org.seasar.cubby.spi.beans.IllegalAttributeException;
import org.seasar.cubby.spi.beans.ParameterizedClassDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBeanDescProvider
implements BeanDescProvider {
    private static final Map<Class<?>, Object> PRIMITIVE_TYPE_DEFAULT_VALUES;
    protected final Map<Class<?>, BeanDesc> beanDescCache = new ConcurrentHashMap(1024);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanDesc getBeanDesc(Class<?> clazz) {
        if (this.beanDescCache.containsKey(clazz)) {
            return this.beanDescCache.get(clazz);
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz2) {
            if (this.beanDescCache.containsKey(clazz)) {
                return this.beanDescCache.get(clazz);
            }
            BeanDesc beanDesc = this.createBeanDesc(clazz);
            this.beanDescCache.put(clazz, beanDesc);
            return beanDesc;
        }
    }

    protected BeanDesc createBeanDesc(Class<?> clazz) {
        return new BeanDescImpl(clazz);
    }

    protected static ParameterizedClassDesc createParameterizedClassDesc(Type type) {
        Class<?> rowClass = DefaultBeanDescProvider.getRawClass(type);
        if (rowClass == null) {
            return null;
        }
        Type[] parameterTypes = DefaultBeanDescProvider.getGenericParameter(type);
        if (parameterTypes == null) {
            ParameterizedClassDescImpl desc = new ParameterizedClassDescImpl(rowClass);
            return desc;
        }
        ParameterizedClassDesc[] parameterDescs = new ParameterizedClassDesc[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterDescs[i] = DefaultBeanDescProvider.createParameterizedClassDesc(parameterTypes[i]);
        }
        ParameterizedClassDescImpl desc = new ParameterizedClassDescImpl(rowClass, parameterDescs);
        return desc;
    }

    protected static Class<?> getRawClass(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return DefaultBeanDescProvider.getRawClass(parameterizedType.getRawType());
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> rawClass = DefaultBeanDescProvider.getRawClass(genericArrayType.getGenericComponentType());
            return Array.newInstance(rawClass, 0).getClass();
        }
        return null;
    }

    protected static Type[] getGenericParameter(Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            return ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments();
        }
        if (GenericArrayType.class.isInstance(type)) {
            return DefaultBeanDescProvider.getGenericParameter(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType());
        }
        return null;
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> map = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        map.put(Boolean.TYPE, Boolean.FALSE);
        map.put(Character.TYPE, Character.valueOf('\u0000'));
        map.put(Byte.TYPE, Byte.valueOf((byte)0));
        map.put(Short.TYPE, Short.valueOf((short)0));
        map.put(Integer.TYPE, Integer.valueOf(0));
        map.put(Long.TYPE, Long.valueOf(0L));
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Double.TYPE, Double.valueOf(0.0));
        PRIMITIVE_TYPE_DEFAULT_VALUES = Collections.unmodifiableMap(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ParameterizedClassDescImpl
    implements ParameterizedClassDesc {
        protected Class<?> rawClass;
        protected ParameterizedClassDesc[] arguments;

        public ParameterizedClassDescImpl() {
        }

        public ParameterizedClassDescImpl(Class<?> rawClass) {
            this.rawClass = rawClass;
        }

        public ParameterizedClassDescImpl(Class<?> rawClass, ParameterizedClassDesc[] arguments) {
            this.rawClass = rawClass;
            this.arguments = arguments;
        }

        @Override
        public boolean isParameterizedClass() {
            return this.arguments != null;
        }

        @Override
        public Class<?> getRawClass() {
            return this.rawClass;
        }

        @Override
        public ParameterizedClassDesc[] getArguments() {
            return this.arguments;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FieldAttribute
    implements Attribute {
        private final Class<?> clazz;
        private final Field field;
        private final boolean writable;
        private final ParameterizedClassDesc parameterizedClassDesc;

        public FieldAttribute(Class<?> clazz, Field field) {
            this.clazz = clazz;
            this.field = field;
            this.writable = (field.getModifiers() & 0x10) == 0;
            this.parameterizedClassDesc = DefaultBeanDescProvider.createParameterizedClassDesc(field.getGenericType());
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public Object getValue(Object target) {
            try {
                if (this.isReadable() && !this.field.isAccessible()) {
                    this.field.setAccessible(true);
                    Object value = this.field.get(target);
                    this.field.setAccessible(false);
                    return value;
                }
                Object value = this.field.get(target);
                return value;
            }
            catch (IllegalAccessException e) {
                throw new IllegalAttributeException(this.clazz, this.field.getName(), e);
            }
        }

        @Override
        public void setValue(Object target, Object value) {
            try {
                if (this.isWritable() && !this.field.isAccessible()) {
                    this.field.setAccessible(true);
                    this.field.set(target, value);
                    this.field.setAccessible(false);
                } else {
                    this.field.set(target, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalAttributeException(this.clazz, this.field.getName(), e);
            }
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return this.writable;
        }

        @Override
        public ParameterizedClassDesc getParameterizedClassDesc() {
            return this.parameterizedClassDesc;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.field.getAnnotation(annotationClass);
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.field.isAnnotationPresent(annotationClass);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldAttribute other = (FieldAttribute)obj;
            return !(this.field == null ? other.field != null : !this.field.equals(other.field));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PropertyAttribute
    implements Attribute {
        private final Class<?> clazz;
        private final PropertyDescriptor propertyDescriptor;
        private final ParameterizedClassDesc parameterizedClassDesc;
        private final Map<Class<? extends Annotation>, Annotation> annotationCache = new HashMap<Class<? extends Annotation>, Annotation>();

        PropertyAttribute(Class<?> clazz, PropertyDescriptor propertyDescriptor) {
            this.clazz = clazz;
            this.propertyDescriptor = propertyDescriptor;
            this.parameterizedClassDesc = propertyDescriptor.getReadMethod() != null ? DefaultBeanDescProvider.createParameterizedClassDesc(propertyDescriptor.getReadMethod().getGenericReturnType()) : (propertyDescriptor.getWriteMethod() != null ? DefaultBeanDescProvider.createParameterizedClassDesc(propertyDescriptor.getWriteMethod().getParameterTypes()[0]) : null);
        }

        @Override
        public String getName() {
            return this.propertyDescriptor.getName();
        }

        @Override
        public Class<?> getType() {
            return this.propertyDescriptor.getPropertyType();
        }

        @Override
        public boolean isReadable() {
            return this.propertyDescriptor.getReadMethod() != null;
        }

        @Override
        public boolean isWritable() {
            return this.propertyDescriptor.getWriteMethod() != null;
        }

        @Override
        public Object getValue(Object target) throws IllegalAttributeException {
            Method method = this.propertyDescriptor.getReadMethod();
            if (method == null) {
                throw new IllegalAttributeException(this.clazz, this.propertyDescriptor.getName(), new IllegalStateException(this.propertyDescriptor.getName() + " is not readable."));
            }
            try {
                return method.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAttributeException(this.clazz, this.propertyDescriptor.getName(), e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new IllegalAttributeException(this.clazz, this.propertyDescriptor.getName(), e);
            }
        }

        @Override
        public void setValue(Object target, Object value) throws IllegalAttributeException {
            Method method = this.propertyDescriptor.getWriteMethod();
            if (method == null) {
                throw new IllegalAttributeException(this.clazz, this.propertyDescriptor.getName(), new IllegalStateException(this.propertyDescriptor.getName() + " is not writable."));
            }
            try {
                Class<?> propertyType = this.propertyDescriptor.getPropertyType();
                if (value == null && propertyType.isPrimitive()) {
                    method.invoke(target, PRIMITIVE_TYPE_DEFAULT_VALUES.get(propertyType));
                } else {
                    method.invoke(target, value);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalAttributeException(this.clazz, this.propertyDescriptor.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAttributeException(this.clazz, this.propertyDescriptor.getName(), e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new IllegalAttributeException(this.clazz, this.propertyDescriptor.getName(), e);
            }
        }

        @Override
        public ParameterizedClassDesc getParameterizedClassDesc() {
            return this.parameterizedClassDesc;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            T annotation;
            T annotation2;
            if (this.annotationCache.containsKey(annotationClass)) {
                return (T)((Annotation)annotationClass.cast(this.annotationCache.get(annotationClass)));
            }
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (readMethod != null && (annotation2 = PropertyAttribute.findAnnotation(annotationClass, readMethod)) != null) {
                this.annotationCache.put((Class<? extends Annotation>)annotationClass, (Annotation)annotation2);
                return annotation2;
            }
            Method writeMethod = this.propertyDescriptor.getWriteMethod();
            if (writeMethod != null && (annotation = PropertyAttribute.findAnnotation(annotationClass, writeMethod)) != null) {
                this.annotationCache.put((Class<? extends Annotation>)annotationClass, (Annotation)annotation);
                return annotation;
            }
            this.annotationCache.put(annotationClass, null);
            return null;
        }

        private static <T extends Annotation> T findAnnotation(Class<T> annotationClass, Method method) {
            String methodName = method.getName();
            Class[] parameterTypes = method.getParameterTypes();
            Class<?> target = method.getDeclaringClass();
            while (!target.equals(Object.class)) {
                T annotation = PropertyAttribute.getAnnotation(annotationClass, target, methodName, parameterTypes);
                if (annotation != null) {
                    return annotation;
                }
                T annotationOfInterfaces = PropertyAttribute.getAnnotationOfInterfaces(annotationClass, target, methodName, parameterTypes);
                if (annotationOfInterfaces != null) {
                    return annotationOfInterfaces;
                }
                target = target.getSuperclass();
            }
            return null;
        }

        private static <T extends Annotation> T getAnnotationOfInterfaces(Class<T> annotationClass, Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                T annotation = PropertyAttribute.getAnnotation(annotationClass, interfaceClass, methodName, parameterTypes);
                if (annotation == null) continue;
                return annotation;
            }
            return null;
        }

        private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz, String methodName, Class[] parameterTypes) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                if (method.isAnnotationPresent(annotationClass)) {
                    return method.getAnnotation(annotationClass);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return null;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.getAnnotation(annotationClass) != null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.propertyDescriptor == null ? 0 : this.propertyDescriptor.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyAttribute other = (PropertyAttribute)obj;
            return !(this.propertyDescriptor == null ? other.propertyDescriptor != null : !this.propertyDescriptor.equals(other.propertyDescriptor));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BeanDescImpl
    implements BeanDesc {
        private final Class<?> clazz;
        private final Map<String, Attribute> propertyAttributeMap;
        private final Map<String, List<Attribute>> fieldAttributesMap;

        public BeanDescImpl(Class<?> clazz) {
            this.clazz = clazz;
            this.propertyAttributeMap = this.collectPropertyAttributeMap(clazz);
            this.fieldAttributesMap = this.collectFieldAttributesMap(clazz);
        }

        protected Map<String, Attribute> collectPropertyAttributeMap(Class<?> clazz) {
            BeanInfo beanInfo;
            LinkedHashMap<String, Attribute> propertyAttributes = new LinkedHashMap<String, Attribute>();
            try {
                beanInfo = Introspector.getBeanInfo(clazz);
            }
            catch (IntrospectionException e) {
                throw new IllegalStateException(e);
            }
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.getName();
                PropertyAttribute propertyDesc = new PropertyAttribute(clazz, propertyDescriptor);
                propertyAttributes.put(propertyName, propertyDesc);
            }
            return propertyAttributes;
        }

        protected Map<String, List<Attribute>> collectFieldAttributesMap(Class<?> clazz) {
            LinkedHashMap<String, List<Attribute>> fieldAttributes = new LinkedHashMap<String, List<Attribute>>();
            for (Field field : ReflectionUtils.findAllDeclaredField(clazz)) {
                List<FieldAttribute> fieldDescs;
                String fieldName = field.getName();
                if (!fieldAttributes.containsKey(fieldName)) {
                    fieldDescs = new ArrayList();
                    fieldAttributes.put(fieldName, fieldDescs);
                } else {
                    fieldDescs = (List)fieldAttributes.get(fieldName);
                }
                FieldAttribute attributes = new FieldAttribute(clazz, field);
                fieldDescs.add(attributes);
            }
            return fieldAttributes;
        }

        @Override
        public boolean hasPropertyAttribute(String name) {
            return this.propertyAttributeMap.containsKey(name);
        }

        @Override
        public Attribute getPropertyAttribute(String name) throws AttributeNotFoundException {
            if (!this.propertyAttributeMap.containsKey(name)) {
                throw new AttributeNotFoundException(this.clazz, name);
            }
            return this.propertyAttributeMap.get(name);
        }

        @Override
        public Set<Attribute> findtPropertyAttributes() {
            LinkedHashSet<Attribute> attributes = new LinkedHashSet<Attribute>();
            attributes.addAll(this.propertyAttributeMap.values());
            return Collections.unmodifiableSet(attributes);
        }

        @Override
        public Attribute getFieldAttribute(String fieldName) {
            if (!this.fieldAttributesMap.containsKey(fieldName)) {
                throw new AttributeNotFoundException(this.clazz, fieldName);
            }
            return this.fieldAttributesMap.get(fieldName).get(0);
        }

        @Override
        public boolean hasFieldAttribute(String fieldName) {
            return this.fieldAttributesMap.containsKey(fieldName);
        }

        @Override
        public Set<Attribute> findFieldAttributes() {
            LinkedHashSet<Attribute> fieldAttributes = new LinkedHashSet<Attribute>();
            for (List<Attribute> attributes : this.fieldAttributesMap.values()) {
                fieldAttributes.addAll(attributes);
            }
            return Collections.unmodifiableSet(fieldAttributes);
        }

        @Override
        public Set<Attribute> findAllAttributes() {
            LinkedHashSet<Attribute> attributes = new LinkedHashSet<Attribute>();
            attributes.addAll(this.findtPropertyAttributes());
            attributes.addAll(this.findFieldAttributes());
            return Collections.unmodifiableSet(attributes);
        }

        @Override
        public Set<Attribute> findAttributesAnnotatedWith(Class<? extends Annotation> annotationClass) {
            LinkedHashSet<Attribute> attributes = new LinkedHashSet<Attribute>();
            for (Attribute attribute : this.findAllAttributes()) {
                if (!attribute.isAnnotationPresent(annotationClass)) continue;
                attributes.add(attribute);
            }
            return Collections.unmodifiableSet(attributes);
        }
    }
}

