/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.env;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.InputStreamReaderUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.ReaderUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TextUtil;
import org.seasar.framework.util.URLUtil;

public class Env {
    public static final String PRODUCT = "product";
    public static final String UT = "ut";
    public static final String CT = "ct";
    public static final String IT = "it";
    public static final String DEFAULT_FILE_PATH = "env.txt";
    private static final Logger logger = Logger.getLogger(Env.class);
    private static String value;
    private static String filePath;
    private static File file;
    private static long lastModified;

    private Env() {
    }

    public static void initialize() {
        Env.setFilePath(DEFAULT_FILE_PATH);
    }

    public static String getValue() {
        if (file != null && file.lastModified() > lastModified) {
            Env.calcValue();
        }
        if (StringUtil.isEmpty(value)) {
            return PRODUCT;
        }
        return value;
    }

    public static boolean setValueIfAbsent(String newValue) {
        if (value == null) {
            value = newValue;
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0115", new Object[]{value, filePath});
            }
            return true;
        }
        return false;
    }

    public static String adjustPath(String path) {
        String env = Env.getValue();
        if (PRODUCT.equals(env)) {
            return path;
        }
        int index = path.lastIndexOf(46);
        if (index < 0) {
            return path;
        }
        String p = path.substring(0, index);
        String ext = path.substring(index + 1);
        return p + "_" + env + "." + ext;
    }

    public static String getFilePath() {
        return filePath;
    }

    public static void setFilePath(String filePath) {
        if (filePath == null) {
            throw new EmptyRuntimeException("filePath");
        }
        Env.filePath = filePath;
        URL url = ResourceUtil.getResourceNoException(filePath);
        if (url == null) {
            file = null;
            Env.clearValue();
            return;
        }
        file = ResourceUtil.getFile(url);
        if (file != null) {
            Env.calcValue();
        } else {
            Env.calcValue(url);
        }
    }

    public static void setFile(File fileObj) throws FileNotFoundException {
        if (fileObj == null) {
            throw new EmptyRuntimeException("fileObj");
        }
        if (!fileObj.exists()) {
            throw new FileNotFoundException(fileObj.getAbsolutePath());
        }
        filePath = fileObj.getAbsolutePath();
        file = fileObj;
        Env.calcValue();
    }

    protected static void calcValue() {
        value = TextUtil.readUTF8(file);
        if (value != null) {
            value = value.trim();
        }
        lastModified = file.lastModified();
        if (logger.isDebugEnabled()) {
            logger.log("DSSR0114", new Object[]{value, filePath});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void calcValue(URL url) {
        InputStream is = URLUtil.openStream(url);
        try {
            InputStreamReader reader = InputStreamReaderUtil.create(is, "UTF-8");
            value = ReaderUtil.readText(reader);
            if (value != null) {
                value = value.trim();
            }
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0114", new Object[]{value, filePath});
            }
        }
        finally {
            InputStreamUtil.close(is);
        }
    }

    protected static void clearValue() {
        value = null;
        lastModified = 0L;
    }

    static {
        filePath = DEFAULT_FILE_PATH;
        Env.initialize();
    }
}

