/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

import java.util.Hashtable;

public class LRUCache {
    private int cacheSize;
    private Hashtable nodes;
    private int currentSize = 0;
    private CacheNode first;
    private CacheNode last;

    public LRUCache(int i) {
        this.cacheSize = i;
        this.nodes = new Hashtable(i);
    }

    public Object get(Object key) {
        CacheNode node = (CacheNode)this.nodes.get(key);
        if (node != null) {
            this.moveToHead(node);
            return node.value;
        }
        return null;
    }

    public void put(Object key, Object value) {
        CacheNode node = (CacheNode)this.nodes.get(key);
        if (node == null) {
            if (this.currentSize >= this.cacheSize) {
                if (this.last != null) {
                    this.nodes.remove(this.last.key);
                }
                this.removeLast();
            } else {
                ++this.currentSize;
            }
            node = new CacheNode();
        }
        node.value = value;
        node.key = key;
        this.moveToHead(node);
        this.nodes.put(key, node);
    }

    public Object remove(Object key) {
        CacheNode node = (CacheNode)this.nodes.get(key);
        if (node != null) {
            if (node.prev != null) {
                node.prev.next = node.next;
            }
            if (node.next != null) {
                node.next.prev = node.prev;
            }
            if (this.last == node) {
                this.last = node.prev;
            }
            if (this.first == node) {
                this.first = node.next;
            }
        }
        return node;
    }

    public void clear() {
        this.first = null;
        this.last = null;
    }

    private void removeLast() {
        if (this.last != null) {
            if (this.last.prev != null) {
                this.last.prev.next = null;
            } else {
                this.first = null;
            }
            this.last = this.last.prev;
        }
    }

    private void moveToHead(CacheNode node) {
        if (node == this.first) {
            return;
        }
        if (node.prev != null) {
            node.prev.next = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        }
        if (this.last == node) {
            this.last = node.prev;
        }
        if (this.first != null) {
            node.next = this.first;
            this.first.prev = node;
        }
        this.first = node;
        node.prev = null;
        if (this.last == null) {
            this.last = this.first;
        }
    }

    class CacheNode {
        CacheNode prev;
        CacheNode next;
        Object value;
        Object key;

        CacheNode() {
        }
    }
}

