/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.types.BigDecimalType;
import org.seasar.extension.dataset.types.BinaryType;
import org.seasar.extension.dataset.types.BooleanType;
import org.seasar.extension.dataset.types.ObjectType;
import org.seasar.extension.dataset.types.StringType;
import org.seasar.extension.dataset.types.TimestampType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.util.MapUtil;

public class ColumnTypes {
    public static final ColumnType STRING = new StringType();
    public static final ColumnType NOT_TRIM_STRING = new StringType(false);
    public static final ColumnType BIGDECIMAL = new BigDecimalType();
    public static final ColumnType TIMESTAMP = new TimestampType();
    public static final ColumnType BINARY = new BinaryType();
    public static final ColumnType OBJECT = new ObjectType();
    public static final ColumnType BOOLEAN = new BooleanType();
    private static Map typesByClass = MapUtil.createHashMap((int)20);
    private static Map typesBySqlType = MapUtil.createHashMap((int)20);

    protected ColumnTypes() {
    }

    public static ValueType getValueType(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ValueTypes.BIGDECIMAL;
            }
            case 16: {
                return ValueTypes.BOOLEAN;
            }
            case 91: 
            case 92: 
            case 93: {
                return ValueTypes.TIMESTAMP;
            }
            case -4: 
            case -3: 
            case -2: {
                return ValueTypes.BINARY;
            }
            case -1: 
            case 1: 
            case 12: {
                return ValueTypes.STRING;
            }
        }
        return ValueTypes.OBJECT;
    }

    public static ColumnType getColumnType(int type) {
        ColumnType columnType = (ColumnType)typesBySqlType.get(new Integer(type));
        if (columnType != null) {
            return columnType;
        }
        return OBJECT;
    }

    public static ColumnType getColumnType(Object value) {
        if (value == null) {
            return OBJECT;
        }
        return ColumnTypes.getColumnType(value.getClass());
    }

    public static ColumnType getColumnType(Class clazz) {
        ColumnType columnType = (ColumnType)typesByClass.get(clazz);
        if (columnType != null) {
            return columnType;
        }
        return OBJECT;
    }

    public static ColumnType registerColumnType(int sqlType, ColumnType columnType) {
        return typesBySqlType.put(new Integer(sqlType), columnType);
    }

    public static ColumnType registerColumnType(Class clazz, ColumnType columnType) {
        return typesByClass.put(clazz, columnType);
    }

    static {
        ColumnTypes.registerColumnType(String.class, STRING);
        ColumnTypes.registerColumnType(Short.TYPE, BIGDECIMAL);
        ColumnTypes.registerColumnType(Short.class, BIGDECIMAL);
        ColumnTypes.registerColumnType(Integer.TYPE, BIGDECIMAL);
        ColumnTypes.registerColumnType(Integer.class, BIGDECIMAL);
        ColumnTypes.registerColumnType(Long.TYPE, BIGDECIMAL);
        ColumnTypes.registerColumnType(Long.class, BIGDECIMAL);
        ColumnTypes.registerColumnType(Float.TYPE, BIGDECIMAL);
        ColumnTypes.registerColumnType(Float.class, BIGDECIMAL);
        ColumnTypes.registerColumnType(Double.TYPE, BIGDECIMAL);
        ColumnTypes.registerColumnType(Double.class, BIGDECIMAL);
        ColumnTypes.registerColumnType(Boolean.TYPE, BOOLEAN);
        ColumnTypes.registerColumnType(Boolean.class, BOOLEAN);
        ColumnTypes.registerColumnType(BigDecimal.class, BIGDECIMAL);
        ColumnTypes.registerColumnType(Timestamp.class, TIMESTAMP);
        ColumnTypes.registerColumnType(Date.class, TIMESTAMP);
        ColumnTypes.registerColumnType(java.util.Date.class, TIMESTAMP);
        ColumnTypes.registerColumnType(Calendar.class, TIMESTAMP);
        ColumnTypes.registerColumnType(new byte[0].getClass(), BINARY);
        ColumnTypes.registerColumnType(-6, BIGDECIMAL);
        ColumnTypes.registerColumnType(5, BIGDECIMAL);
        ColumnTypes.registerColumnType(4, BIGDECIMAL);
        ColumnTypes.registerColumnType(-5, BIGDECIMAL);
        ColumnTypes.registerColumnType(7, BIGDECIMAL);
        ColumnTypes.registerColumnType(6, BIGDECIMAL);
        ColumnTypes.registerColumnType(8, BIGDECIMAL);
        ColumnTypes.registerColumnType(3, BIGDECIMAL);
        ColumnTypes.registerColumnType(2, BIGDECIMAL);
        ColumnTypes.registerColumnType(16, BOOLEAN);
        ColumnTypes.registerColumnType(91, TIMESTAMP);
        ColumnTypes.registerColumnType(92, TIMESTAMP);
        ColumnTypes.registerColumnType(93, TIMESTAMP);
        ColumnTypes.registerColumnType(-2, BINARY);
        ColumnTypes.registerColumnType(-3, BINARY);
        ColumnTypes.registerColumnType(-4, BINARY);
        ColumnTypes.registerColumnType(1, STRING);
        ColumnTypes.registerColumnType(-1, STRING);
        ColumnTypes.registerColumnType(12, STRING);
    }
}

