/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.Element;
import net.skirnir.freyja.EvaluationRuntimeException;
import net.skirnir.freyja.ExpressionEvaluator;
import net.skirnir.freyja.FreyjaRuntimeException;
import net.skirnir.freyja.StringUtils;
import net.skirnir.freyja.TagEvaluatorUtils;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.zpt.Default;
import net.skirnir.freyja.zpt.TalTagEvaluator;
import net.skirnir.freyja.zpt.ZptTemplateContext;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Path;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.FormDesc;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.impl.FormDescImpl;
import org.seasar.ymir.extension.creator.impl.MetaAnnotationDescImpl;
import org.seasar.ymir.extension.creator.mapping.impl.ActionSelectorSeedImpl;
import org.seasar.ymir.extension.zpt.AnalyzerContext;
import org.seasar.ymir.extension.zpt.AnalyzerUtils;
import org.seasar.ymir.extension.zpt.DescWrapper;
import org.seasar.ymir.util.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerTalTagEvaluator
extends TalTagEvaluator {
    private static final String PREFIX_STRING_EXPRESSION = "string:";
    private static final String KW_LOCAL = "local";
    private static final String KW_GLOBAL = "global ";
    private static final Set<String> BOOLEAN_ATTRIBUTE_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("compact", "noshade", "multiple", "readonly", "disabled", "nohref", "ismap", "noresize", "checked", "selected", "declare", "defer", "nowrap")));
    private static final String TAL_DEFINE = "tal:define";
    private static final String TAL_REPEAT = "tal:repeat";
    private static final String TAL_ATTRIBUTES = "tal:attributes";

    public String[] getSpecialTagPatternStrings() {
        return new String[]{"form", "input", "select", "textarea", "button"};
    }

    public String[] getSpecialAttributePatternStrings() {
        return (String[])ArrayUtil.add((Object[])super.getSpecialAttributePatternStrings(), (Object[])new String[]{"href", "src"});
    }

    public TemplateContext newContext() {
        return new AnalyzerContext();
    }

    /*
     * Exception decompiling
     */
    public String evaluate(TemplateContext context, String name, Attribute[] attrs, Element[] body) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 11[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Set<String> getRuntimeAttributeNameSet(AnalyzerContext analyzerContext, Attribute[] attrs) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < attrs.length; ++i) {
            if (!TAL_ATTRIBUTES.equals(attrs[i].getName())) continue;
            String[] statements = this.parseStatements(TagEvaluatorUtils.defilter((String)attrs[i].getValue()));
            for (int j = 0; j < statements.length; ++j) {
                String statement = statements[j];
                int delim = statement.indexOf(32);
                String name = statement.substring(0, delim).trim();
                String expression = statement.substring(delim).trim();
                if (this.isStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(analyzerContext, expression) || this.isDefinedAndStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(analyzerContext, expression)) continue;
                set.add(name);
            }
            break;
        }
        return set;
    }

    boolean isDefinedAndStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(AnalyzerContext analyzerContext, String expression) {
        if (!AnalyzerUtils.isValidVariableName(expression)) {
            return false;
        }
        return this.isStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(analyzerContext, analyzerContext.getDefinedVariableExpression(expression));
    }

    boolean isStringTypeExpressionAndContainsRuntimeParameterOnlyAsIndex(AnalyzerContext analyzerContext, String expression) {
        int idx;
        if (expression == null) {
            return false;
        }
        if (!expression.startsWith(PREFIX_STRING_EXPRESSION)) {
            return false;
        }
        expression = expression.substring(PREFIX_STRING_EXPRESSION.length()).trim();
        int pre = 0;
        while ((idx = expression.indexOf(36, pre)) >= 0) {
            if (idx == 0 || expression.charAt(idx - 1) != '[') {
                return false;
            }
            if (idx + 1 < expression.length() && expression.charAt(idx + 1) == '{') {
                int rightParen = this.findEndEdge(expression, idx + 1);
                if (rightParen + 1 >= expression.length() || expression.charAt(rightParen + 1) != ']') {
                    analyzerContext.addWarning(expression, rightParen + 2);
                    return false;
                }
                pre = rightParen + 2;
                continue;
            }
            int rightEdge = expression.indexOf(93, idx + 1);
            if (rightEdge < 0 || !AnalyzerUtils.isValidVariableName(expression.substring(idx + 1, rightEdge))) {
                analyzerContext.addWarning(expression, idx + 2);
                return false;
            }
            pre = rightEdge + 1;
        }
        return true;
    }

    int findEndEdge(String expression, int idx) {
        int depth = 0;
        while (idx < expression.length()) {
            char ch = expression.charAt(idx);
            if (ch == '{') {
                ++depth;
            } else if (ch == '}') {
                --depth;
            }
            if (depth == 0) break;
            ++idx;
        }
        return idx;
    }

    FormDesc registerTransitionClassDesc(AnalyzerContext analyzerContext, Map<String, Attribute> attrMap, Set<String> runtimeAttributeNameSet, String attrName, String methodName, boolean form) {
        SourceCreator creator = analyzerContext.getSourceCreator();
        String url = this.getAttributeValue(attrMap, attrName, null);
        if ("#".equals(url)) {
            return null;
        }
        Path path = this.constructPath(analyzerContext.getPath(), url);
        if (path == null) {
            return null;
        }
        HttpMethod method = HttpMethod.enumOf((String)methodName);
        ClassDesc classDesc = creator.buildTransitionClassDesc(DescPool.getDefault(), path.getTrunk(), method, path.getParameterMap());
        if (classDesc == null) {
            return null;
        }
        if (form) {
            String name;
            ClassDesc dtoClassDesc = null;
            String formName = null;
            if (creator.getSourceCreatorSetting().isFormDtoCreationFeatureEnabled() && !runtimeAttributeNameSet.contains("name") && AnalyzerUtils.isValidVariableName(name = this.getAttributeValue(attrMap, "name", null))) {
                formName = name;
                PropertyDesc propertyDesc = analyzerContext.getSourceCreator().addPropertyDesc(classDesc, name, 0, analyzerContext.getPageClassName());
                propertyDesc.setAnnotationDesc(new MetaAnnotationDescImpl("property", new String[]{name}, new Class[0]));
                dtoClassDesc = propertyDesc.getTypeDesc().getComponentClassDesc();
                dtoClassDesc.setAttribute("formDto", Boolean.TRUE);
                dtoClassDesc.setAttribute("ownerPage", classDesc);
            }
            return new FormDescImpl(creator, classDesc, dtoClassDesc, formName, path.getTrunk(), method);
        }
        MethodDesc methodDesc = creator.newActionMethodDesc(classDesc.getDescPool(), path.getTrunk(), method, new ActionSelectorSeedImpl());
        classDesc.setMethodDesc(methodDesc);
        MethodDesc prerenderMethodDesc = creator.newPrerenderActionMethodDesc(classDesc.getDescPool(), path.getTrunk(), method, new ActionSelectorSeedImpl());
        classDesc.setMethodDesc(prerenderMethodDesc);
        return null;
    }

    Path constructPath(String basePath, String pathWithParameters) {
        if (pathWithParameters == null) {
            return null;
        }
        return new Path(ServletUtils.toAbsolutePath((String)basePath, (String)pathWithParameters));
    }

    AnnotationResult findAnnotation(TemplateContext context, String name, Attribute[] attrs) {
        String behaviorDuplicateTag = context.getProperty("behavior.duplicate-tag");
        String annotation = null;
        ArrayList<Attribute> attrList = new ArrayList<Attribute>();
        for (int i = 0; i < attrs.length; ++i) {
            if ("tal:annotation".equals(attrs[i].getName())) {
                if (annotation != null && !"ignore".equals(behaviorDuplicateTag)) {
                    throw new EvaluationRuntimeException("Duplicate tag found: " + attrs[i].getName() + ": " + TagEvaluatorUtils.getBeginTagString((String)name, (Attribute[])attrs)).setLineNumber(attrs[i].getLineNumber()).setColumnNumber(attrs[i].getColumnNumber());
                }
                annotation = attrs[i].getValue();
                continue;
            }
            attrList.add(attrs[i]);
        }
        return new AnnotationResult(annotation, attrList.toArray(new Attribute[0]));
    }

    PropertyDesc processParameterTag(AnalyzerContext context, Map<String, Attribute> attrMap, String annotation, FormDesc formDesc) {
        String name = this.getAttributeValue(attrMap, "name", null);
        if (name != null && AnalyzerUtils.shouldGeneratePropertyForParameter(name)) {
            return context.getRequestParameterPropertyDesc(formDesc.getActionPageClassDesc(), name, 3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Attribute> evaluate(ZptTemplateContext context, Attribute[] attrs) {
        ExpressionEvaluator expEvaluator = context.getExpressionEvaluator();
        VariableResolver varResolver = context.getVariableResolver();
        ArrayList<Attribute> attrList = new ArrayList<Attribute>();
        Attribute attributesAttr = null;
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i].getName().startsWith("tal:")) {
                if (!TAL_ATTRIBUTES.equals(attrs[i].getName())) continue;
                attributesAttr = attrs[i];
                continue;
            }
            attrList.add(attrs[i]);
        }
        if (attributesAttr != null) {
            try {
                context.setProcessingAttributeName(TAL_ATTRIBUTES);
                attrs = this.processAttributes(context, expEvaluator, varResolver, attributesAttr, attrs, true);
            }
            finally {
                context.setProcessingAttributeName(null);
            }
        }
        return TagEvaluatorUtils.toMap((Attribute[])attrs);
    }

    AnalyzerContext toAnalyzerContext(TemplateContext context) {
        return (AnalyzerContext)context;
    }

    String getAttributeValue(Map<String, Attribute> attrMap, String name, String defaultValue) {
        Attribute attr = attrMap.get(name);
        if (attr != null) {
            return TagEvaluatorUtils.defilter((String)attr.getValue());
        }
        return defaultValue;
    }

    protected boolean evaluateCondition(TemplateContext context, ExpressionEvaluator expEvaluator, VariableResolver varResolver, String condition) {
        if (condition.trim().length() == 0) {
            return false;
        }
        return this.evaluateIfTrue(context, expEvaluator, varResolver, condition);
    }

    protected boolean evaluateOmitTag(TemplateContext context, ExpressionEvaluator expEvaluator, VariableResolver varResolver, String condition) {
        if (condition.trim().length() == 0) {
            return true;
        }
        return this.evaluateIfTrue(context, expEvaluator, varResolver, condition);
    }

    protected boolean evaluateIfTrue(TemplateContext context, ExpressionEvaluator expEvaluator, VariableResolver varResolver, String condition) {
        DescWrapper wrapper;
        PropertyDesc pd;
        Object evaluated = expEvaluator.evaluate(context, varResolver, condition);
        if (evaluated instanceof DescWrapper && (pd = (wrapper = (DescWrapper)evaluated).getPropertyDesc()) != null && !pd.isTypeAlreadySet(Integer.MAX_VALUE)) {
            pd.decrementReferCount();
            pd.setMayBoolean(true);
        }
        return expEvaluator.isTrue(evaluated);
    }

    protected void processDefine(ZptTemplateContext talContext, ExpressionEvaluator expEvaluator, VariableResolver varResolver, Attribute attr) {
        super.processDefine(talContext, expEvaluator, varResolver, attr);
        AnalyzerContext analyzerContext = this.toAnalyzerContext((TemplateContext)talContext);
        String[] statements = this.parseStatements(TagEvaluatorUtils.defilter((String)attr.getValue()));
        for (int i = 0; i < statements.length; ++i) {
            String statement = statements[i];
            int scope = 0;
            if (statement.startsWith(KW_LOCAL)) {
                scope = 0;
                statement = StringUtils.trimLeft((String)statement.substring(KW_LOCAL.length()));
            } else if (statement.startsWith(KW_GLOBAL)) {
                scope = 1;
                statement = StringUtils.trimLeft((String)statement.substring(KW_GLOBAL.length()));
            }
            int sp = statement.indexOf(32);
            String varname = statement.substring(0, sp).trim();
            String value = StringUtils.trimLeft((String)statement.substring(sp + 1));
            analyzerContext.defineVariableExpression(scope, varname, value);
        }
    }

    protected Attribute[] processAttributes(ZptTemplateContext talContext, ExpressionEvaluator expEvaluator, VariableResolver varResolver, Attribute attr, Attribute[] htmlAttrs, boolean isHTML) {
        LinkedHashMap<String, Object> attrMap = new LinkedHashMap<String, Object>();
        String[] statements = this.parseStatements(TagEvaluatorUtils.defilter((String)attr.getValue()));
        for (int i = 0; i < statements.length; ++i) {
            Object evaluated;
            String statement = statements[i];
            int sp = statement.indexOf(32);
            if (sp < 0) {
                throw new EvaluationRuntimeException("Syntax error: " + statement).setLineNumber(attr.getLineNumber()).setColumnNumber(attr.getColumnNumber());
            }
            String varname = statement.substring(0, sp).trim();
            String value = StringUtils.trimLeft((String)statement.substring(sp + 1));
            String oldTargetName = talContext.getTargetName();
            try {
                talContext.setTargetName(varname);
                evaluated = expEvaluator.evaluate((TemplateContext)talContext, varResolver, value);
            }
            catch (FreyjaRuntimeException ex) {
                throw ex.setLineNumber(attr.getLineNumber()).setColumnNumber(attr.getColumnNumber());
            }
            catch (RuntimeException ex) {
                throw new EvaluationRuntimeException("Can't evaluate tal:attributes expression", (Throwable)ex).setLineNumber(attr.getLineNumber()).setColumnNumber(attr.getColumnNumber());
            }
            finally {
                talContext.setTargetName(oldTargetName);
            }
            if (evaluated != Default.instance) {
                if (isHTML && BOOLEAN_ATTRIBUTE_SET.contains(varname)) {
                    if (evaluated instanceof DescWrapper) {
                        this.changeTypeToBoolean((DescWrapper)evaluated);
                    }
                    evaluated = expEvaluator.isTrue(evaluated);
                } else if (evaluated != null) {
                    evaluated = this.renderEvaluatedValue((TemplateContext)talContext, evaluated);
                }
            }
            attrMap.put(varname, evaluated);
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>(htmlAttrs.length + attrMap.size());
        for (int i = 0; i < htmlAttrs.length; ++i) {
            String key = htmlAttrs[i].getName();
            if (attrMap.containsKey(key)) {
                Object evaluated = attrMap.get(key);
                if (isHTML && BOOLEAN_ATTRIBUTE_SET.contains(key)) {
                    if (evaluated == Default.instance || ((Boolean)evaluated).booleanValue()) {
                        String quote = htmlAttrs[i].getQuote();
                        if (quote.length() == 0) {
                            quote = "\"";
                        }
                        list.add(new Attribute(key, key, quote));
                    }
                } else if (evaluated != null) {
                    String evaluatedString = Default.instance.equals(evaluated) ? htmlAttrs[i].getValue() : TagEvaluatorUtils.filter((String)evaluated.toString());
                    list.add(new Attribute(key, evaluatedString, htmlAttrs[i].getQuote()));
                }
                attrMap.remove(key);
                continue;
            }
            list.add(htmlAttrs[i]);
        }
        for (Map.Entry entry : attrMap.entrySet()) {
            String key = (String)entry.getKey();
            Object evaluated = entry.getValue();
            if (isHTML && BOOLEAN_ATTRIBUTE_SET.contains(key)) {
                if (evaluated == Default.instance || !((Boolean)evaluated).booleanValue()) continue;
                list.add(new Attribute(key, key, "\""));
                continue;
            }
            if (evaluated == null || evaluated == Default.instance) continue;
            String evaluatedString = TagEvaluatorUtils.filter((String)evaluated.toString());
            list.add(new Attribute(key, evaluatedString, "\""));
        }
        return list.toArray(new Attribute[0]);
    }

    void changeTypeToBoolean(DescWrapper wrapper) {
        PropertyDesc propertyDesc = wrapper.getPropertyDesc();
        if (propertyDesc == null) {
            return;
        }
        if (!propertyDesc.isTypeAlreadySet(2000)) {
            propertyDesc.setTypeDesc(Boolean.TYPE);
            propertyDesc.notifyTypeUpdated(2000);
        }
    }

    static class AnnotationResult {
        private String annotation_;
        private Attribute[] theOtherAttributes_;

        public AnnotationResult(String annotation, Attribute[] theOtherAttributes) {
            this.annotation_ = annotation;
            this.theOtherAttributes_ = theOtherAttributes;
        }

        public String getAnnotation() {
            return this.annotation_;
        }

        public Attribute[] getTheOtherAttributes() {
            return this.theOtherAttributes_;
        }
    }
}

