/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import net.skirnir.freyja.TemplateContext;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.zpt.AnalyzerContext;
import org.seasar.ymir.extension.zpt.DescWrapper;
import org.seasar.ymir.zpt.FormatTypePrefixHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerFormatTypePrefixHandler
extends FormatTypePrefixHandler {
    protected void adjustFormatAndParameter(TemplateContext context, MessageFormat mf, Object[] parameters, Format[] formats, int index) {
        PropertyDesc propertyDesc;
        if (parameters[index] instanceof DescWrapper && (propertyDesc = ((DescWrapper)parameters[index]).getPropertyDesc()) != null && !propertyDesc.isTypeAlreadySet(3000)) {
            Class<?> clazz = ((AnalyzerContext)context).getSourceCreator().getClass(propertyDesc.getTypeDesc().getComponentClassDesc().getName());
            if (formats[index] instanceof DateFormat && !this.isDate(clazz)) {
                propertyDesc.getTypeDesc().setComponentClassDesc(Date.class);
                propertyDesc.notifyTypeUpdated(3000);
            } else if (formats[index] instanceof NumberFormat && !this.isNumber(clazz)) {
                propertyDesc.getTypeDesc().setComponentClassDesc(Integer.class);
                propertyDesc.notifyTypeUpdated(3000);
            }
        }
        super.adjustFormatAndParameter(context, mf, parameters, formats, index);
    }

    private boolean isNumber(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE;
    }

    private boolean isDate(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return true;
        }
        return this.isNumber(clazz);
    }
}

