/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.ymir.extension.creator.AnnotationDesc;
import org.seasar.ymir.extension.creator.Desc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.MetaAnnotationDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.creator.impl.AbstractAnnotatedDesc;
import org.seasar.ymir.extension.creator.impl.MetaAnnotationDescImpl;
import org.seasar.ymir.extension.creator.util.DescUtils;
import org.seasar.ymir.extension.creator.util.GenericsUtils;
import org.seasar.ymir.extension.creator.util.type.Token;
import org.seasar.ymir.extension.creator.util.type.TokenVisitor;
import org.seasar.ymir.extension.creator.util.type.TypeToken;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescImpl
extends AbstractAnnotatedDesc
implements PropertyDesc {
    private static final Log log_ = LogFactory.getLog(PropertyDescImpl.class);
    private DescPool pool_;
    private Desc<?> parent_;
    private String name_;
    private TypeDesc typeDesc_;
    private int mode_;
    private int probability_ = 0;
    private Map<String, AnnotationDesc> annotationDescForGetterMap_ = new TreeMap<String, AnnotationDesc>();
    private Map<String, AnnotationDesc> annotationDescForSetterMap_ = new TreeMap<String, AnnotationDesc>();
    private String getterName_;
    private boolean mayBoolean_;
    private int referCount_;

    public PropertyDescImpl(DescPool pool, String name) {
        this.pool_ = pool;
        this.name_ = name;
        this.setTypeDesc((Type)((Object)String.class));
        this.applyBornOf(this.pool_.getBornOf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDescImpl(DescPool pool, PropertyDescriptor descriptor) {
        Field field;
        this.pool_ = pool;
        this.name_ = descriptor.getName();
        this.setTypeDesc(this.newTypeDesc(descriptor));
        if (descriptor.getReadMethod() != null) {
            this.addMode(1);
            this.setGetterName(descriptor.getReadMethod().getName());
            for (AnnotationDesc annotationDesc : DescUtils.newAnnotationDescs(descriptor.getReadMethod())) {
                this.setAnnotationDescOnGetter(annotationDesc);
            }
        }
        if (descriptor.getWriteMethod() != null) {
            this.addMode(2);
            for (AnnotationDesc annotationDesc : DescUtils.newAnnotationDescs(descriptor.getWriteMethod())) {
                this.setAnnotationDescOnSetter(annotationDesc);
            }
        }
        if ((field = this.findField(descriptor)) != null) {
            for (AnnotationDesc annotationDesc : DescUtils.newAnnotationDescs(field)) {
                this.setAnnotationDesc(annotationDesc);
            }
            if (List.class.isAssignableFrom(descriptor.getPropertyType()) && field != null) {
                Class<?> clazz = descriptor.getReadMethod() != null ? descriptor.getReadMethod().getDeclaringClass() : descriptor.getWriteMethod().getDeclaringClass();
                boolean accessible = field.isAccessible();
                try {
                    field.setAccessible(true);
                    Object instance = ClassUtils.newInstance(field.getDeclaringClass());
                    Object value = field.get(instance);
                    if (value != null) {
                        this.getTypeDesc().setCollectionImplementationClass(value.getClass());
                    }
                }
                catch (Throwable ignore) {
                    log_.debug((Object)("Can't get initial value of field (" + field.getName() + "): class=" + clazz.getName()), ignore);
                }
                finally {
                    field.setAccessible(accessible);
                }
            }
        }
        this.applyBornOf(this.pool_.getBornOf());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name_ == null ? 0 : this.name_.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDescImpl other = (PropertyDescImpl)obj;
        return !(this.name_ == null ? other.name_ != null : !this.name_.equals(other.name_));
    }

    private TypeDesc newTypeDesc(PropertyDescriptor descriptor) {
        Type type = descriptor.getReadMethod() != null ? descriptor.getReadMethod().getGenericReturnType() : descriptor.getWriteMethod().getGenericParameterTypes()[0];
        return this.pool_.newTypeDesc(type);
    }

    private Field findField(PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        Field field = this.pool_.getSourceCreator().findField(descriptor.getReadMethod(), name);
        if (field == null) {
            field = this.pool_.getSourceCreator().findField(descriptor.getWriteMethod(), name);
        }
        return field;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.typeDesc_).append(" ").append(this.name_).append("(");
        if ((this.mode_ & 1) != 0) {
            sb.append("r");
        }
        if ((this.mode_ & 2) != 0) {
            sb.append("w");
        }
        sb.append(")");
        String initialValue = this.getInitialValue();
        if (initialValue != null) {
            sb.append(" = ").append(initialValue);
        }
        return sb.toString();
    }

    @Override
    public DescPool getDescPool() {
        return this.pool_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public TypeDesc getTypeDesc() {
        return this.typeDesc_;
    }

    @Override
    public void setTypeDesc(TypeDesc typeDesc) {
        this.typeDesc_ = typeDesc;
        this.typeDesc_.setParent(this);
    }

    @Override
    public TypeDesc setTypeDesc(Type type) {
        TypeDesc typeDesc = this.pool_.newTypeDesc(type);
        this.setTypeDesc(typeDesc);
        return typeDesc;
    }

    @Override
    public int getMode() {
        return this.mode_;
    }

    @Override
    public void setMode(int mode) {
        this.mode_ = mode;
    }

    @Override
    public void addMode(int mode) {
        this.mode_ |= mode;
    }

    @Override
    public boolean isReadable() {
        return (this.mode_ & 1) != 0;
    }

    @Override
    public boolean isWritable() {
        return (this.mode_ & 2) != 0;
    }

    @Override
    public String getGetterName() {
        return this.getterName_ != null ? this.getterName_ : this.constructGetterName();
    }

    @Override
    public void setGetterName(String getterName) {
        this.getterName_ = getterName;
    }

    String constructGetterName() {
        if ("boolean".equals(this.typeDesc_.getName())) {
            return "is" + DescUtils.capFirst(this.name_);
        }
        return "get" + DescUtils.capFirst(this.name_);
    }

    @Override
    public boolean isTypeAlreadySet(int probability) {
        return this.probability_ >= probability;
    }

    @Override
    public void notifyTypeUpdated(int probability) {
        if (this.isTypeAlreadySet(probability)) {
            throw new IllegalStateException("Can't make probability down: current=" + this.probability_ + ", new=" + probability);
        }
        this.probability_ = probability;
    }

    @Override
    public AnnotationDesc getAnnotationDescOnGetter(String name) {
        return this.annotationDescForGetterMap_.get(name);
    }

    @Override
    public void setAnnotationDescOnGetter(AnnotationDesc annotationDesc) {
        DescUtils.setAnnotationDesc(this.annotationDescForGetterMap_, annotationDesc);
    }

    @Override
    public void removeMetaAnnotationDescOnGetter(String metaName) {
        DescUtils.removeMetaAnnotationDesc(this.annotationDescForGetterMap_, metaName);
    }

    @Override
    public void removeMetaAnnotationDescOnSetter(String metaName) {
        DescUtils.removeMetaAnnotationDesc(this.annotationDescForSetterMap_, metaName);
    }

    @Override
    public AnnotationDesc[] getAnnotationDescsOnGetter() {
        return this.annotationDescForGetterMap_.values().toArray(new AnnotationDesc[0]);
    }

    @Override
    public void setAnnotationDescsOnGetter(AnnotationDesc[] annotationDescs) {
        this.annotationDescForGetterMap_.clear();
        for (AnnotationDesc annotationDesc : annotationDescs) {
            this.setAnnotationDescOnGetter(annotationDesc);
        }
    }

    @Override
    public AnnotationDesc getAnnotationDescOnSetter(String name) {
        return this.annotationDescForSetterMap_.get(name);
    }

    @Override
    public void setAnnotationDescOnSetter(AnnotationDesc annotationDesc) {
        DescUtils.setAnnotationDesc(this.annotationDescForSetterMap_, annotationDesc);
    }

    @Override
    public AnnotationDesc[] getAnnotationDescsOnSetter() {
        return this.annotationDescForSetterMap_.values().toArray(new AnnotationDesc[0]);
    }

    @Override
    public void setAnnotationDescsOnSetter(AnnotationDesc[] annotationDescs) {
        this.annotationDescForSetterMap_.clear();
        for (AnnotationDesc annotationDesc : annotationDescs) {
            this.setAnnotationDescOnSetter(annotationDesc);
        }
    }

    @Override
    public String getMetaFirstValueOnGetter(String name) {
        return DescUtils.getMetaFirstValue(this.annotationDescForGetterMap_, name);
    }

    @Override
    public String getMetaFirstValueOnSetter(String name) {
        return DescUtils.getMetaFirstValue(this.annotationDescForSetterMap_, name);
    }

    @Override
    public String getMetaFirstValueOnGetterOrSetter(String name) {
        String value = this.getMetaFirstValueOnGetter(name);
        if (value == null) {
            value = this.getMetaFirstValueOnSetter(name);
        }
        return value;
    }

    @Override
    public String[] getMetaValueOnGetter(String name) {
        return DescUtils.getMetaValue(this.annotationDescForGetterMap_, name);
    }

    @Override
    public String[] getMetaValueOnSetter(String name) {
        return DescUtils.getMetaValue(this.annotationDescForSetterMap_, name);
    }

    @Override
    public String[] getMetaValueOnGetterOrSetter(String name) {
        String[] value = this.getMetaValueOnGetter(name);
        if (value == null) {
            value = this.getMetaValueOnSetter(name);
        }
        return value;
    }

    @Override
    public Class<?>[] getMetaClassValueOnGetter(String name) {
        return DescUtils.getMetaClassValue(this.annotationDescForGetterMap_, name);
    }

    @Override
    public Class<?>[] getMetaClassValueOnSetter(String name) {
        return DescUtils.getMetaClassValue(this.annotationDescForSetterMap_, name);
    }

    @Override
    public Class<?>[] getMetaClassValueOnGetterOrSetter(String name) {
        Class<?>[] classValue = this.getMetaClassValueOnGetter(name);
        if (classValue == null) {
            classValue = this.getMetaClassValueOnSetter(name);
        }
        return classValue;
    }

    @Override
    public boolean hasMetaOnGetter(String name) {
        return DescUtils.hasMeta(this.annotationDescForGetterMap_, name);
    }

    @Override
    public boolean hasMetaOnSetter(String name) {
        return DescUtils.hasMeta(this.annotationDescForSetterMap_, name);
    }

    @Override
    public boolean hasMetaOnGetterOrSetter(String name) {
        return this.hasMetaOnGetter(name) || this.hasMetaOnSetter(name);
    }

    @Override
    public MetaAnnotationDesc[] getMetaAnnotationDescsOnGetter() {
        return DescUtils.getMetaAnnotationDescs(this.annotationDescForGetterMap_);
    }

    @Override
    public MetaAnnotationDesc[] getMetaAnnotationDescsOnSetter() {
        return DescUtils.getMetaAnnotationDescs(this.annotationDescForSetterMap_);
    }

    @Override
    public String getInitialValue() {
        if (this.typeDesc_ == null) {
            return null;
        }
        String initialValue = null;
        String componentTypeName = this.typeDesc_.getComponentTypeName();
        if (this.typeDesc_.isCollection()) {
            String collectionClassName = this.typeDesc_.getCollectionClassName();
            if (collectionClassName != null) {
                String collectionImplementationClassName = this.typeDesc_.getCollectionImplementationClassName();
                if (collectionImplementationClassName != null) {
                    initialValue = "new " + GenericsUtils.getNormalizedTypeName(collectionImplementationClassName + "<" + componentTypeName + ">") + "()";
                } else if (List.class.getName().equals(collectionClassName)) {
                    initialValue = "new " + GenericsUtils.getNormalizedTypeName(ArrayList.class.getName() + "<" + componentTypeName + ">") + "()";
                }
            } else {
                initialValue = "new " + GenericsUtils.getNormalizedTypeName(componentTypeName) + "[0]";
            }
        } else {
            boolean generateInitialValue = false;
            if (this.pool_.getSourceCreator().isDtoClass(componentTypeName)) {
                Class<?> clazz = DescUtils.getClass(componentTypeName);
                if (clazz != null) {
                    try {
                        clazz.newInstance();
                        generateInitialValue = true;
                    }
                    catch (InstantiationException ignore) {
                    }
                    catch (IllegalAccessException ignore) {}
                } else {
                    generateInitialValue = true;
                }
            }
            if (generateInitialValue) {
                initialValue = "new " + componentTypeName + "()";
            }
        }
        return initialValue;
    }

    @Override
    public String getInitialShortValue() {
        if (this.typeDesc_ == null) {
            return null;
        }
        String initialValue = null;
        String componentTypeName = this.typeDesc_.getComponentTypeName();
        Set<String> touchedClassNameSet = this.getTouchedClassNameSet();
        if (this.typeDesc_.isCollection()) {
            String collectionClassName = this.typeDesc_.getCollectionClassName();
            if (collectionClassName != null) {
                String collectionImplementationClassName = this.typeDesc_.getCollectionImplementationClassName();
                if (collectionImplementationClassName != null) {
                    initialValue = "new " + GenericsUtils.getShortTypeName(collectionImplementationClassName + "<" + componentTypeName + ">") + "()";
                    this.addTypeName(touchedClassNameSet, componentTypeName);
                    touchedClassNameSet.add(collectionImplementationClassName);
                } else if (List.class.getName().equals(collectionClassName)) {
                    initialValue = "new " + GenericsUtils.getShortTypeName(ArrayList.class.getName() + "<" + componentTypeName + ">") + "()";
                    this.addTypeName(touchedClassNameSet, componentTypeName);
                    touchedClassNameSet.add(ArrayList.class.getName());
                }
            } else {
                initialValue = "new " + GenericsUtils.getShortTypeName(componentTypeName) + "[0]";
                this.addTypeName(touchedClassNameSet, componentTypeName);
            }
        } else {
            boolean generateInitialValue = false;
            if (this.pool_.getSourceCreator().isDtoClass(componentTypeName)) {
                Class<?> clazz = DescUtils.getClass(componentTypeName);
                if (clazz != null) {
                    try {
                        clazz.newInstance();
                        generateInitialValue = true;
                    }
                    catch (InstantiationException ignore) {
                    }
                    catch (IllegalAccessException ignore) {}
                } else {
                    generateInitialValue = true;
                }
            }
            if (generateInitialValue) {
                initialValue = "new " + GenericsUtils.getShortTypeName(componentTypeName) + "()";
                this.addTypeName(touchedClassNameSet, componentTypeName);
                touchedClassNameSet.add(componentTypeName);
            }
        }
        return initialValue;
    }

    private void addTypeName(final Set<String> set, String typeName) {
        TypeToken token = new TypeToken(typeName);
        token.accept(new TokenVisitor<Object>(){

            public Object visit(Token acceptor, Object ... parameters) {
                set.add(acceptor.getComponentName());
                return null;
            }
        }, new Object[0]);
    }

    @Override
    public PropertyDesc transcriptTo(PropertyDesc desc) {
        DescPool pool = desc.getDescPool();
        super.transcriptTo(desc);
        if (this.typeDesc_ != null) {
            desc.setTypeDesc(this.typeDesc_.transcriptTo(pool.newTypeDesc(this.typeDesc_)));
        }
        desc.setMode(this.mode_);
        if (this.probability_ > 0) {
            desc.notifyTypeUpdated(this.probability_);
        }
        for (AnnotationDesc annotationDesc : this.getAnnotationDescsOnGetter()) {
            desc.setAnnotationDescOnGetter((AnnotationDesc)annotationDesc.clone());
        }
        for (AnnotationDesc annotationDesc : this.getAnnotationDescsOnSetter()) {
            desc.setAnnotationDescOnSetter((AnnotationDesc)annotationDesc.clone());
        }
        desc.setGetterName(this.getterName_);
        return desc;
    }

    @Override
    public <D extends Desc<?>> D getParent() {
        return (D)this.parent_;
    }

    @Override
    public void setParent(Desc<?> parent) {
        this.parent_ = parent;
    }

    @Override
    public boolean isMayBoolean() {
        return this.mayBoolean_;
    }

    @Override
    public void setMayBoolean(boolean mayBoolean) {
        this.mayBoolean_ = mayBoolean;
    }

    @Override
    public int getReferCount() {
        return this.referCount_;
    }

    @Override
    public void setReferCount(int referCount) {
        this.referCount_ = referCount;
    }

    @Override
    public void incrementReferCount() {
        ++this.referCount_;
    }

    @Override
    public void decrementReferCount() {
        --this.referCount_;
    }

    @Override
    public int getProbability() {
        return this.probability_;
    }

    @Override
    public void addDependingClassNamesTo(Set<String> set) {
        this.addDependingClassNamesTo0(set);
        this.typeDesc_.addDependingClassNamesTo(set);
        for (AnnotationDesc annotationDesc : this.getAnnotationDescsOnGetter()) {
            annotationDesc.addDependingClassNamesTo(set);
        }
        for (AnnotationDesc annotationDesc : this.getAnnotationDescsOnSetter()) {
            annotationDesc.addDependingClassNamesTo(set);
        }
    }

    @Override
    public void setTouchedClassNameSet(Set<String> set) {
        if (this.setTouchedClassNameSet0(set)) {
            return;
        }
        this.typeDesc_.setTouchedClassNameSet(set);
        for (AnnotationDesc annotationDesc : this.getAnnotationDescsOnGetter()) {
            annotationDesc.setTouchedClassNameSet(set);
        }
        for (AnnotationDesc annotationDesc : this.getAnnotationDescsOnSetter()) {
            annotationDesc.setTouchedClassNameSet(set);
        }
    }

    void applyBornOf(String bornOf) {
        if (bornOf == null) {
            return;
        }
        AnnotationDesc annotationDescOnGetter = DescUtils.newBornOfMetaAnnotationDesc(this.getMetaValueOnGetter("bornOf"), bornOf);
        this.removeMetaAnnotationDescOnGetter("bornOf");
        this.setAnnotationDescOnGetter(annotationDescOnGetter);
        AnnotationDesc annotationDescOnSetter = DescUtils.newBornOfMetaAnnotationDesc(this.getMetaValueOnSetter("bornOf"), bornOf);
        this.removeMetaAnnotationDescOnSetter("bornOf");
        this.setAnnotationDescOnSetter(annotationDescOnSetter);
        AnnotationDesc annotationDesc = DescUtils.newBornOfMetaAnnotationDesc(this.getMetaValue("bornOf"), bornOf);
        this.removeMetaAnnotationDesc("bornOf");
        this.setAnnotationDesc(annotationDesc);
    }

    @Override
    public boolean removeBornOf(String bornOf) {
        ArrayList<String> valueList;
        if (bornOf == null || bornOf.startsWith("request:")) {
            return false;
        }
        boolean mayFieldBeRemoved = false;
        String[] values = this.getMetaValueOnGetter("bornOf");
        if (values != null) {
            this.removeMetaAnnotationDescOnGetter("bornOf");
            valueList = new ArrayList<String>();
            for (String value : values) {
                if (value.equals(bornOf)) continue;
                valueList.add(value);
            }
            values = valueList.toArray(new String[0]);
            if (values.length == 0) {
                this.mode_ &= 0xFFFFFFFE;
            } else {
                this.setAnnotationDescOnGetter(new MetaAnnotationDescImpl("bornOf", values));
            }
        }
        if ((values = this.getMetaValueOnSetter("bornOf")) != null) {
            this.removeMetaAnnotationDescOnSetter("bornOf");
            valueList = new ArrayList();
            for (String value : values) {
                if (value.equals(bornOf)) continue;
                valueList.add(value);
            }
            values = valueList.toArray(new String[0]);
            if (values.length == 0) {
                this.mode_ &= 0xFFFFFFFD;
            } else {
                this.setAnnotationDescOnSetter(new MetaAnnotationDescImpl("bornOf", values));
            }
        }
        if ((values = this.getMetaValue("bornOf")) != null) {
            this.removeMetaAnnotationDesc("bornOf");
            valueList = new ArrayList();
            for (String value : values) {
                if (value.equals(bornOf)) continue;
                valueList.add(value);
            }
            values = valueList.toArray(new String[0]);
            if (values.length == 0) {
                mayFieldBeRemoved = true;
            } else {
                this.setAnnotationDesc(new MetaAnnotationDescImpl("bornOf", values));
            }
        }
        DescUtils.removeBornOfFromAttributes(bornOf, this.getAttributeMap());
        return this.mode_ == 0 && mayFieldBeRemoved;
    }
}

