/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.convention.YmirNamingConvention;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassDescBag;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.extension.creator.WebappSourceResourceCollector;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.extension.creator.action.impl.SystemInformation;
import org.seasar.ymir.extension.creator.impl.PathMetaDataCollectorRule;
import org.seasar.ymir.extension.creator.impl.TemplateCollectorRule;

public class SystemConsoleAction
extends AbstractAction
implements UpdateAction {
    private static final String PARAM_APPLY = "__ymir__apply";

    public SystemConsoleAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    public Response act(Request request, PathMetaData pathMetaData) {
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("confirmUpdateAllClasses".equals(subTask)) {
            return this.actConfirmUpdateAllClasses(request, pathMetaData);
        }
        if ("updateAllClasses".equals(subTask)) {
            return this.actUpdateAllClasses(request, pathMetaData);
        }
        if ("initializeTemplateCheckedTime".equals(subTask)) {
            return this.actInitializeTemplateCheckedTime(request, pathMetaData);
        }
        if ("setSourceCreatorEnabledWithThisTemplate".equals(subTask)) {
            return this.actSetSourceCreatorEnabledWithThisTemplate(request, pathMetaData);
        }
        if ("createPathMappings".equals(subTask)) {
            return this.actCreatePathMappings(request, pathMetaData);
        }
        return this.actDefault(request, pathMetaData);
    }

    Response actDefault(Request request, PathMetaData pathMetaData) {
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", request.getMethod());
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("systemInformation", new SystemInformation(this.getSourceCreator().getApplication(), this.getYmirNamingConvention()));
        variableMap.put("sourceCreatorEnabledWithThisTemplate", this.getSourceCreator().getSourceCreatorSetting().isSourceCreatorEnabledWith(request.getPath()));
        return this.getSourceCreator().getResponseCreator().createResponse("systemConsole", variableMap);
    }

    YmirNamingConvention getYmirNamingConvention() {
        try {
            return (YmirNamingConvention)this.getSourceCreator().getApplication().getS2Container().getComponent(YmirNamingConvention.class);
        }
        catch (ComponentNotFoundRuntimeException ex) {
            return null;
        }
    }

    Response actConfirmUpdateAllClasses(Request request, PathMetaData pathMetaData) {
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        ClassDescBag classDescBag = this.getSourceCreator().gatherClassDescs(this.newDescPool(), null, true, this.gatherPathMetaDatas());
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("classDescBag", classDescBag);
        return this.getSourceCreator().getResponseCreator().createResponse("systemConsole_confirmUpdateAllClasses", variableMap);
    }

    Response actUpdateAllClasses(Request request, PathMetaData pathMetaData) {
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        ClassDescBag classDescBag = this.getSourceCreator().gatherClassDescs(this.newDescPool(), null, true, this.gatherPathMetaDatas());
        String[] appliedClassNames = request.getParameterValues(PARAM_APPLY);
        HashSet<String> appliedClassNameSet = new HashSet<String>();
        if (appliedClassNames != null) {
            appliedClassNameSet.addAll(Arrays.asList(appliedClassNames));
        }
        ClassDesc[] classDescs = classDescBag.getClassDescs();
        for (int i = 0; i < classDescs.length; ++i) {
            String name = classDescs[i].getName();
            if (appliedClassNameSet.contains(name)) continue;
            classDescBag.remove(name);
        }
        this.getSourceCreator().updateClasses(classDescBag);
        boolean successfullySynchronized = this.synchronizeResources(new String[]{this.getRootPackagePath()});
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("classDescBag", classDescBag);
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("systemConsole_updateAllClasses", variableMap);
    }

    PathMetaData[] gatherPathMetaDatas() {
        return new WebappSourceResourceCollector<PathMetaData>(this.getSourceCreator().getWebappSourceRoot(), new PathMetaDataCollectorRule(this.getSourceCreator())).collect().toArray(new PathMetaData[0]);
    }

    Response actInitializeTemplateCheckedTime(Request request, PathMetaData pathMetaData) {
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        Properties prop = this.getSourceCreator().getSourceCreatorProperties();
        Enumeration<?> enm = prop.propertyNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            if (!name.startsWith("updateClassesAction.checkedTime.")) continue;
            prop.remove(name);
        }
        List<Template> templateList = new WebappSourceResourceCollector<Template>(this.getSourceCreator().getWebappSourceRoot(), new TemplateCollectorRule(this.getSourceCreator())).collect();
        for (Template template : templateList) {
            prop.setProperty("updateClassesAction.checkedTime." + template.getPath(), String.valueOf(System.currentTimeMillis()));
        }
        this.getSourceCreator().saveSourceCreatorProperties();
        boolean successfullySynchronized = this.synchronizeResources(new String[]{this.adjustPath(this.getSourceCreator().getSourceCreatorPropertiesFile().getAbsolutePath())});
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("systemConsole_initializeTemplateCheckedTime", variableMap);
    }

    Response actSetSourceCreatorEnabledWithThisTemplate(Request request, PathMetaData pathMetaData) {
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        this.getSourceCreator().getSourceCreatorSetting().setSourceCreatorEnabledWith(request.getPath(), PropertyUtils.valueOf((String)request.getParameter("value"), (boolean)false));
        boolean successfullySynchronized = this.synchronizeResources(new String[]{this.adjustPath(this.getSourceCreator().getSourceCreatorPropertiesFile().getAbsolutePath())});
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("systemConsole_setSourceCreatorEnabledWithThisTemplate", variableMap);
    }

    Response actCreatePathMappings(Request request, PathMetaData pathMetaData) {
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        this.updateMapping(this.gatherPathMetaDatas());
        boolean successfullySynchronized = this.synchronizeResources(new String[]{".settings/org.seasar.ymir.extension.mapping.prefs"});
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("systemConsole_createPathMappings", variableMap);
    }
}

