/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.io.InputStream;
import java.util.HashMap;
import org.seasar.kvasir.util.io.InputStreamFactory;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.impl.AsIsInputStreamFactory;
import org.seasar.ymir.response.SelfContainedResponse;
import org.seasar.ymir.response.VoidResponse;
import org.seasar.ymir.util.ServletUtils;

public class ResourceAction
implements UpdateAction {
    private static final String PATH_PREFIX_RESOURCE = "/__ymir__/resource/";
    private static final String PACKAGE_PREFIX_RESOURCE = "org/seasar/ymir/extension/resource/";
    private static final String DEFAULT_CONTENTTYPE = "application/octet-stream";
    private static final String PATH_SOURCECREATOR_JS = "js/sourceCreator.js";
    private SourceCreator sourceCreator_;

    public ResourceAction(SourceCreator sourceCreator) {
        this.sourceCreator_ = sourceCreator;
    }

    public Response act(Request request, PathMetaData pathMetaData) {
        String resourcePath = this.getResourcePath(pathMetaData);
        if (resourcePath == null) {
            return VoidResponse.INSTANCE;
        }
        String resourceFullPath = PACKAGE_PREFIX_RESOURCE + resourcePath;
        if (resourcePath.equals(PATH_SOURCECREATOR_JS)) {
            HashMap<String, SourceCreator> variableMap = new HashMap<String, SourceCreator>();
            variableMap.put("sourceCreator", this.sourceCreator_);
            variableMap.put("request", (SourceCreator)request);
            return this.sourceCreator_.getResponseCreator().createResponse(this.getClass().getClassLoader().getResource(resourceFullPath), variableMap);
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceFullPath);
        if (in == null) {
            return VoidResponse.INSTANCE;
        }
        String contentType = this.sourceCreator_.getServletContext().getMimeType(resourcePath);
        if (contentType == null) {
            contentType = DEFAULT_CONTENTTYPE;
        }
        return new SelfContainedResponse((InputStreamFactory)new AsIsInputStreamFactory(in), contentType);
    }

    String getResourcePath(PathMetaData pathMetaData) {
        String path = ServletUtils.normalizePath((String)pathMetaData.getPath());
        if (path.startsWith(PATH_PREFIX_RESOURCE)) {
            return path.substring(PATH_PREFIX_RESOURCE.length());
        }
        return null;
    }
}

