/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.seasar.kvasir.util.io.IORuntimeException;
import org.seasar.kvasir.util.io.IOUtils;
import org.seasar.kvasir.util.io.impl.FileResource;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.action.UpdateByExceptionAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.message.MessagesNotFoundRuntimeException;

public class CreateMessagesAction
extends AbstractAction
implements UpdateByExceptionAction {
    private static final String SUFFIX_XPROPERTIES = ".xproperties";
    protected static final String PARAM_MESSAGESNAME = "__ymir__messagesName";

    public CreateMessagesAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    public Response act(Request request, PathMetaData pathMetaData, Throwable t) {
        if (!this.getSourceCreatorSetting().isMessagesCreationFeatureEnabled()) {
            return null;
        }
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("create".equals(subTask)) {
            return this.actCreate(request, pathMetaData);
        }
        return this.actDefault(request, pathMetaData, t);
    }

    Response actDefault(Request request, PathMetaData pathMetaData, Throwable t) {
        MessagesNotFoundRuntimeException mnfre = (MessagesNotFoundRuntimeException)t;
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("messageKey", mnfre.getMessageKey());
        variableMap.put("messagesName", mnfre.getMessagesName());
        return this.getSourceCreator().getResponseCreator().createResponse("createMessages", variableMap);
    }

    Response actCreate(Request request, PathMetaData pathMetaData) {
        String method = request.getParameter("__ymir__method");
        if (method == null) {
            return null;
        }
        String messagesName = request.getParameter(PARAM_MESSAGESNAME);
        if (messagesName == null) {
            return null;
        }
        this.createMessages(messagesName);
        boolean successfullySynchronized = this.synchronizeResources(new String[]{this.getResourcesPath()});
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("method", method);
        variableMap.put("messagesName", messagesName);
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("createMessages_create", variableMap);
    }

    void createMessages(String messagesName) {
        OutputStream os;
        try {
            os = new FileResource(this.getSourceCreator().getResourcesDirectory()).getChildResource(messagesName + SUFFIX_XPROPERTIES).getOutputStream();
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
        IOUtils.writeString((OutputStream)os, (String)"", (String)"UTF-8", (boolean)false);
    }
}

