/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action;

import java.util.HashMap;
import java.util.Map;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.extension.creator.action.Condition;
import org.seasar.ymir.extension.creator.action.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSelector<T> {
    private Map<Object, T> strategyMap_ = new HashMap<Object, T>();

    public ActionSelector<T> register(Condition condition, T action) {
        State classBound = condition.getClassBound();
        State classExists = condition.getClassExists();
        State templateExists = condition.getTemplateExists();
        HttpMethod method = condition.getMethod();
        if (classBound == State.ANY) {
            this.register(new Condition(State.FALSE, classExists, templateExists, method), action);
            this.register(new Condition(State.TRUE, classExists, templateExists, method), action);
        } else if (classExists == State.ANY) {
            this.register(new Condition(classBound, State.FALSE, templateExists, method), action);
            this.register(new Condition(classBound, State.TRUE, templateExists, method), action);
        } else if (templateExists == State.ANY) {
            this.register(new Condition(classBound, classExists, State.FALSE, method), action);
            this.register(new Condition(classBound, classExists, State.TRUE, method), action);
        } else {
            this.strategyMap_.put(condition, action);
        }
        return this;
    }

    public ActionSelector<T> register(Object condition, T action) {
        this.strategyMap_.put(condition, action);
        return this;
    }

    public T getAction(Object condition) {
        return this.strategyMap_.get(condition);
    }
}

