/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.skirnir.freyja.EvaluationRuntimeException;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.zpt.ZptTemplateContext;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.ClassType;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.FormDesc;
import org.seasar.ymir.extension.creator.PropertyDesc;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.TypeDesc;
import org.seasar.ymir.extension.zpt.AnalyzerVariableResolver;
import org.seasar.ymir.extension.zpt.DescWrapper;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.util.BeanUtils;
import org.seasar.ymir.util.FlexibleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerContext
extends ZptTemplateContext {
    static final char CHAR_ARRAY_LPAREN = '[';
    static final char CHAR_ARRAY_RPAREN = ']';
    private SourceCreator sourceCreator_;
    private HttpMethod method_;
    private String pageClassName_;
    private FormDesc formDesc_;
    private boolean repeatedPropertyGeneratedAsList_;
    private VariableResolver variableResolver_;
    private Set<String> usedClassNameSet_ = new HashSet<String>();
    private Set<String> ignoreVariableSet_ = new HashSet<String>();
    private String path_;
    private Stack<Map<String, String>> variableExpressions_ = new Stack();
    private Map<String, String> globalVariableExpression_ = new HashMap<String, String>();
    private int repeatDepth_;
    private Notes warnings_ = new Notes();

    public VariableResolver getVariableResolver() {
        if (this.variableResolver_ == null) {
            this.variableResolver_ = new AnalyzerVariableResolver(super.getVariableResolver());
        }
        return this.variableResolver_;
    }

    public void setVariableResolver(VariableResolver varResolver) {
        super.setVariableResolver(varResolver);
        this.variableResolver_ = null;
    }

    public void setIgnoreVariables(String[] ignoreVariables) {
        if (ignoreVariables == null) {
            this.ignoreVariableSet_.clear();
        } else {
            this.ignoreVariableSet_.addAll(Arrays.asList(ignoreVariables));
        }
    }

    public boolean shouldIgnoreVariable(String name) {
        return this.ignoreVariableSet_.contains(name);
    }

    public void defineVariable(int scope, String name, Object value) {
        if (value instanceof DescWrapper) {
            ((DescWrapper)value).setVariableName(name, false, null, 3000);
        }
        super.defineVariable(scope, name, value);
    }

    public ZptTemplateContext.RepeatInfo pushRepeatInfo(String name, Object[] objs) {
        ++this.repeatDepth_;
        if (objs != null && objs.length == 1 && objs[0] instanceof DescWrapper) {
            DescWrapper wrapper = (DescWrapper)objs[0];
            wrapper.setVariableName(name, true, this.repeatedPropertyGeneratedAsList_ ? List.class.getName() : null, 3000);
            PropertyDesc pd = wrapper.getPropertyDesc();
            ClassDesc valueClassDesc = pd != null ? pd.getTypeDesc().getComponentClassDesc() : wrapper.getValueClassDesc();
            objs[0] = new DescWrapper(this, valueClassDesc);
        }
        return super.pushRepeatInfo(name, objs);
    }

    public void popRepeatInfo(String name) {
        super.popRepeatInfo(name);
        --this.repeatDepth_;
    }

    public boolean isInRepeat() {
        return this.repeatDepth_ > 0;
    }

    public HttpMethod getMethod() {
        return this.method_;
    }

    public void setMethod(HttpMethod method) {
        this.method_ = method;
    }

    boolean isAvailable(String className) {
        return this.sourceCreator_.getClass(className) != null;
    }

    public String getPageClassName() {
        return this.pageClassName_;
    }

    public void setPageClassName(String pageClassName) {
        this.pageClassName_ = pageClassName;
    }

    public ClassDesc getPageClassDesc() {
        return DescPool.getDefault().getClassDesc(this.getPageClassName());
    }

    public SourceCreator getSourceCreator() {
        return this.sourceCreator_;
    }

    public void setSourceCreator(SourceCreator sourceCreator) {
        this.sourceCreator_ = sourceCreator;
    }

    public FormDesc getFormDesc() {
        return this.formDesc_;
    }

    public void setFormDesc(FormDesc formDesc) {
        this.formDesc_ = formDesc;
    }

    public void close() {
        this.getPageClassDesc();
        this.sourceCreator_.finishAnalyzing(DescPool.getDefault());
        HashSet<ClassDesc> usedClassDescSet = new HashSet<ClassDesc>();
        for (ClassDesc classDesc : DescPool.getDefault().getGeneratedClassDescs()) {
            if (!this.isPage(classDesc) && !this.isUsedClassName(classDesc.getName())) continue;
            this.registerDependingClassDescs(classDesc, usedClassDescSet);
        }
        Iterator<ClassDesc> itr = DescPool.getDefault().iterator();
        while (itr.hasNext()) {
            ClassDesc classDesc;
            classDesc = itr.next();
            if (usedClassDescSet.contains(classDesc) && !this.sourceCreator_.isOuter(classDesc)) continue;
            itr.remove();
        }
    }

    private void registerDependingClassDescs(ClassDesc classDesc, Set<ClassDesc> usedClassDescSet) {
        if (!usedClassDescSet.add(classDesc)) {
            return;
        }
        for (PropertyDesc pd : classDesc.getPropertyDescs()) {
            ClassDesc cd = pd.getTypeDesc().getComponentClassDesc();
            if (!this.sourceCreator_.isDtoClass(cd.getName())) continue;
            this.registerDependingClassDescs(cd, usedClassDescSet);
        }
    }

    private boolean isTypeOf(ClassDesc classDesc, ClassType type) {
        return classDesc.isTypeOf(type) && !this.sourceCreator_.isOuter(classDesc);
    }

    private boolean isPage(ClassDesc classDesc) {
        return this.isTypeOf(classDesc, ClassType.PAGE);
    }

    public PropertyDesc getRequestParameterPropertyDesc(ClassDesc classDesc, String requestParameterName, int mode) {
        int dot = requestParameterName.indexOf(46);
        if (dot < 0) {
            return this.getSingleRequestParameterPropertyDesc(classDesc, requestParameterName, mode);
        }
        String baseName = requestParameterName.substring(0, dot);
        PropertyDesc propertyDesc = this.getSingleRequestParameterPropertyDesc(classDesc, baseName, 1);
        this.replaceTypeToGeneratedClassIfNeedToAddProperty(propertyDesc, BeanUtils.getFirstSimpleSegment((String)requestParameterName.substring(dot + 1)), classDesc);
        return this.getRequestParameterPropertyDesc(propertyDesc.getTypeDesc().getComponentClassDesc(), requestParameterName.substring(dot + 1), mode);
    }

    public void replaceTypeToGeneratedClassIfNeedToAddProperty(PropertyDesc propertyDesc, String propertyName, ClassDesc classDesc) {
        if (!propertyDesc.isTypeAlreadySet(Integer.MAX_VALUE) && this.sourceCreator_.isOuter(propertyDesc.getTypeDesc().getComponentClassDesc()) && !this.hasProperty(propertyDesc.getTypeDesc().getComponentClassDesc().getName(), propertyName)) {
            TypeDesc typeDesc = classDesc.getDescPool().newTypeDesc(this.sourceCreator_.findPropertyClassName(propertyDesc.getName(), this.sourceCreator_.getGeneratedClassName(classDesc.getName(), this.pageClassName_)));
            propertyDesc.setTypeDesc(typeDesc);
            if (!propertyDesc.isTypeAlreadySet(1000)) {
                propertyDesc.notifyTypeUpdated(1000);
            }
        }
    }

    public boolean hasProperty(String className, String propertyName) {
        return this.sourceCreator_.getPropertyDescriptor(className, propertyName) != null;
    }

    private PropertyDesc getSingleRequestParameterPropertyDesc(ClassDesc classDesc, String requestParameterName, int mode) {
        boolean collection = false;
        String collectionClassName = null;
        String collectionImplementationClassName = null;
        int lparen = requestParameterName.indexOf(91);
        int rparen = requestParameterName.indexOf(93);
        if (lparen >= 0 && rparen > lparen) {
            collection = true;
            collectionClassName = List.class.getName();
            collectionImplementationClassName = FlexibleList.class.getName();
            requestParameterName = requestParameterName.substring(0, lparen);
        }
        PropertyDesc propertyDesc = this.sourceCreator_.addPropertyDesc(classDesc, requestParameterName, mode, null, collection, collectionClassName, 4000, this.pageClassName_);
        if (collection) {
            propertyDesc.getTypeDesc().setCollectionImplementationClassName(collectionImplementationClassName);
        }
        propertyDesc.incrementReferCount();
        return propertyDesc;
    }

    public boolean isUsedClassName(String className) {
        return this.usedClassNameSet_.contains(className);
    }

    public void setUsedClassName(String className) {
        this.usedClassNameSet_.add(className);
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void pushVariableScope() {
        super.pushVariableScope();
        this.variableExpressions_.push(new HashMap());
    }

    public void popVariableScope() {
        super.popVariableScope();
        this.variableExpressions_.pop();
    }

    public void defineVariableExpression(int scope, String name, String expression) {
        if (scope == 0) {
            this.variableExpressions_.peek().put(name, expression);
        } else if (scope == 1) {
            this.globalVariableExpression_.put(name, expression);
        } else {
            throw new EvaluationRuntimeException("Unknown scope: " + scope);
        }
    }

    public String getDefinedVariableExpression(String name) {
        String expression = null;
        if (!this.variableExpressions_.isEmpty()) {
            expression = this.variableExpressions_.peek().get(name);
        }
        if (expression == null) {
            expression = this.globalVariableExpression_.get(name);
        }
        return expression;
    }

    public boolean isRepeatedPropertyGeneratedAsList() {
        return this.repeatedPropertyGeneratedAsList_;
    }

    public void setRepeatedPropertyGeneratedAsList(boolean repeatedPropertyGeneratedAsList) {
        this.repeatedPropertyGeneratedAsList_ = repeatedPropertyGeneratedAsList;
    }

    public void addWarning(String expression, int columnNumber) {
        this.warnings_.add(new Note("warning.zpt.syntaxError", new Object[]{this.getElement().getLineNumber(), this.getElement().getColumnNumber(), expression, columnNumber}));
    }

    public Notes getWarnings() {
        return this.warnings_;
    }

    public void setWarnings(Notes warnings) {
        this.warnings_ = warnings;
    }
}

